/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.test;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.duracloud.common.model.AclType;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.StorageProvider;

public class MockRetryStorageProvider
implements StorageProvider {
    private static int getSpaceContentsAttempts = 0;

    public Iterator<String> getSpaces() {
        throw new StorageException("getSpaces is not retried", false);
    }

    public Iterator<String> getSpaceContents(String spaceId, String prefix) {
        return this.getSpaceContentsChunked(spaceId, prefix, 0L, null).iterator();
    }

    public List<String> getSpaceContentsChunked(String spaceId, String prefix, long maxResults, String marker) {
        int attemptsBeforeSuccess = Integer.valueOf(spaceId);
        if (getSpaceContentsAttempts < attemptsBeforeSuccess) {
            ++getSpaceContentsAttempts;
            throw new StorageException(attemptsBeforeSuccess + " calls required before success.", true);
        }
        ArrayList<String> retries = new ArrayList<String>();
        retries.add(String.valueOf(getSpaceContentsAttempts));
        getSpaceContentsAttempts = 0;
        return retries;
    }

    public void createSpace(String spaceId) {
    }

    public void deleteSpace(String spaceId) {
    }

    public Map<String, String> getSpaceProperties(String spaceId) {
        return null;
    }

    public void setSpaceProperties(String spaceId, Map<String, String> spaceProperties) {
    }

    public Map<String, AclType> getSpaceACLs(String spaceId) {
        return null;
    }

    public void setSpaceACLs(String spaceId, Map<String, AclType> spaceACLs) {
    }

    public String addContent(String spaceId, String contentId, String contentMimeType, Map<String, String> userProperties, long contentSize, String contentChecksum, InputStream content) {
        return null;
    }

    public String copyContent(String sourceSpaceId, String sourceContentId, String destSpaceId, String destContentId) {
        return null;
    }

    public InputStream getContent(String spaceId, String contentId) {
        return null;
    }

    public void deleteContent(String spaceId, String contentId) {
    }

    public void setContentProperties(String spaceId, String contentId, Map<String, String> contentProperties) {
    }

    public Map<String, String> getContentProperties(String spaceId, String contentId) {
        return null;
    }
}

