/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.aop;

import java.util.HashMap;
import java.util.Map;
import org.duracloud.storage.error.TaskException;
import org.duracloud.storage.provider.TaskProvider;
import org.duracloud.storage.provider.TaskProviderFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.framework.ProxyFactoryBean;

public class AOPTaskProviderFactoryDecorator
implements TaskProviderFactory {
    private TaskProviderFactory factory;
    private PointcutAdvisor advisor;
    private Map<String, TaskProvider> providerMap;

    public AOPTaskProviderFactoryDecorator(TaskProviderFactory factory, PointcutAdvisor advisor) {
        this.factory = factory;
        this.advisor = advisor;
        this.providerMap = new HashMap();
    }

    public TaskProvider getTaskProvider() {
        return this.getTaskProvider(null);
    }

    public TaskProvider getTaskProvider(String storageAccountId) throws TaskException {
        TaskProvider provider = (TaskProvider)this.providerMap.get(storageAccountId);
        if (provider == null) {
            provider = this.factory.getTaskProvider(storageAccountId);
            ProxyFactoryBean proxyFactoryBean = new ProxyFactoryBean();
            proxyFactoryBean.setTargetClass(TaskProvider.class);
            proxyFactoryBean.setTarget((Object)provider);
            proxyFactoryBean.addAdvisor((Advisor)this.advisor);
            provider = (TaskProvider)proxyFactoryBean.getObject();
            this.providerMap.put(storageAccountId, provider);
        }
        return provider;
    }
}

