/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.duracloud.audit.provider.AuditStorageProvider;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.common.queue.aws.SQSTaskQueue;
import org.duracloud.common.queue.noop.NoopTaskQueue;
import org.duracloud.common.util.UserUtil;
import org.duracloud.durastore.test.MockRetryStorageProvider;
import org.duracloud.durastore.test.MockVerifyCreateStorageProvider;
import org.duracloud.durastore.test.MockVerifyDeleteStorageProvider;
import org.duracloud.durastore.util.ACLStorageProvider;
import org.duracloud.durastore.util.ProviderFactoryBase;
import org.duracloud.glacierstorage.GlacierStorageProvider;
import org.duracloud.irodsstorage.IrodsStorageProvider;
import org.duracloud.rackspacestorage.RackspaceStorageProvider;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.sdscstorage.SDSCStorageProvider;
import org.duracloud.snapshotstorage.SnapshotStorageProvider;
import org.duracloud.storage.domain.AuditConfig;
import org.duracloud.storage.domain.DuraStoreInitConfig;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.domain.StorageAccountManager;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.BrokeredStorageProvider;
import org.duracloud.storage.provider.StatelessStorageProvider;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.provider.StorageProviderBase;
import org.duracloud.storage.util.StorageProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProviderFactoryImpl
extends ProviderFactoryBase
implements StorageProviderFactory {
    private Logger log = LoggerFactory.getLogger(StorageProviderFactoryImpl.class);
    private StatelessStorageProvider statelessProvider;
    private Map<String, StorageProvider> storageProviders;
    private UserUtil userUtil;
    private TaskQueue auditQueue;
    private boolean cacheStorageProvidersOnInit = false;

    public StorageProviderFactoryImpl(StorageAccountManager storageAccountManager, StatelessStorageProvider statelessStorageProvider, UserUtil userUtil) {
        this(storageAccountManager, statelessStorageProvider, userUtil, false);
    }

    public StorageProviderFactoryImpl(StorageAccountManager storageAccountManager, StatelessStorageProvider statelessStorageProvider, UserUtil userUtil, boolean cacheStorageProvidersOnInit) {
        super(storageAccountManager);
        this.statelessProvider = statelessStorageProvider;
        this.storageProviders = new ConcurrentHashMap();
        this.userUtil = userUtil;
        this.cacheStorageProvidersOnInit = cacheStorageProvidersOnInit;
    }

    public void initialize(DuraStoreInitConfig initConfig, String instanceHost, String instancePort) throws StorageException {
        super.initialize(initConfig, instanceHost, instancePort);
        this.configureAuditQueue();
        this.initializeStorageProviders();
    }

    private void initializeStorageProviders() {
        this.storageProviders = new ConcurrentHashMap();
        if (this.cacheStorageProvidersOnInit) {
            this.log.info("Caching storage providers on init is enabled: building storage provider cache...");
            Iterator ids = this.getAccountManager().getStorageAccountIds();
            while (ids.hasNext()) {
                this.getStorageProvider((String)ids.next());
            }
        }
    }

    private void configureAuditQueue() {
        AuditConfig auditConfig = this.getInitConfig().getAuditConfig();
        if (null == auditConfig) {
            this.auditQueue = new NoopTaskQueue();
        } else {
            String queueName = auditConfig.getAuditQueueName();
            if (null == queueName) {
                this.auditQueue = new NoopTaskQueue();
            } else {
                String auditUsername = auditConfig.getAuditUsername();
                String auditPassword = auditConfig.getAuditPassword();
                if (null != auditUsername && null != auditPassword) {
                    System.setProperty("aws.accessKeyId", auditUsername);
                    System.setProperty("aws.secretKey", auditPassword);
                }
                this.auditQueue = new SQSTaskQueue(queueName);
            }
        }
    }

    public TaskQueue getAuditQueue() {
        return this.auditQueue;
    }

    public List<StorageAccount> getStorageAccounts() {
        ArrayList<StorageAccount> accts = new ArrayList<StorageAccount>();
        Iterator ids = this.getAccountManager().getStorageAccountIds();
        while (ids.hasNext()) {
            accts.add(this.getAccountManager().getStorageAccount((String)ids.next()));
        }
        return accts;
    }

    public StorageProvider getStorageProvider() throws StorageException {
        return this.getStorageProvider(null);
    }

    public StorageProvider getStorageProvider(String storageAccountId) throws StorageException {
        if (this.storageProviders.containsKey(storageAccountId = this.checkStorageAccountId(storageAccountId))) {
            return (StorageProvider)this.storageProviders.get(storageAccountId);
        }
        StorageAccountManager storageAccountManager = this.getAccountManager();
        StorageAccount account = storageAccountManager.getStorageAccount(storageAccountId);
        if (account == null) {
            account = storageAccountManager.getPrimaryStorageAccount();
            storageAccountId = account.getId();
        }
        String username = account.getUsername();
        String password = account.getPassword();
        StorageProviderType type = account.getType();
        S3StorageProvider storageProvider = null;
        if (type.equals((Object)StorageProviderType.AMAZON_S3)) {
            storageProvider = new S3StorageProvider(username, password, account.getOptions());
        } else if (type.equals((Object)StorageProviderType.AMAZON_GLACIER)) {
            storageProvider = new GlacierStorageProvider(username, password);
        } else if (type.equals((Object)StorageProviderType.RACKSPACE)) {
            storageProvider = new RackspaceStorageProvider(username, password);
        } else if (type.equals((Object)StorageProviderType.SDSC)) {
            storageProvider = new SDSCStorageProvider(username, password);
        } else if (type.equals((Object)StorageProviderType.IRODS)) {
            storageProvider = new IrodsStorageProvider(username, password, account.getOptions());
        } else if (type.equals((Object)StorageProviderType.SNAPSHOT)) {
            storageProvider = new SnapshotStorageProvider(username, password);
        } else if (type.equals((Object)StorageProviderType.TEST_RETRY)) {
            storageProvider = new MockRetryStorageProvider();
        } else if (type.equals((Object)StorageProviderType.TEST_VERIFY_CREATE)) {
            storageProvider = new MockVerifyCreateStorageProvider();
        } else if (type.equals((Object)StorageProviderType.TEST_VERIFY_DELETE)) {
            storageProvider = new MockVerifyDeleteStorageProvider();
        } else {
            throw new StorageException("Unsupported storage provider type (" + type.name() + ")  associated with storage account (" + storageAccountId + "): unable to create");
        }
        AuditStorageProvider auditProvider = new AuditStorageProvider((StorageProvider)storageProvider, storageAccountManager.getAccountName(), storageAccountId, type.getName(), this.userUtil, this.auditQueue);
        if (storageProvider instanceof StorageProviderBase) {
            ((StorageProviderBase)storageProvider).setWrappedStorageProvider((StorageProvider)auditProvider);
        }
        ACLStorageProvider aclProvider = new ACLStorageProvider((StorageProvider)auditProvider);
        BrokeredStorageProvider brokeredProvider = new BrokeredStorageProvider(this.statelessProvider, (StorageProvider)aclProvider, type, storageAccountId);
        this.storageProviders.put(storageAccountId, brokeredProvider);
        return brokeredProvider;
    }

    private String checkStorageAccountId(String storageAccountId) {
        if (null == storageAccountId) {
            return this.getAccountManager().getPrimaryStorageAccount().getId();
        }
        return storageAccountId;
    }

    public void expireStorageProvider(String storageAccountId) {
        storageAccountId = this.checkStorageAccountId(storageAccountId);
        this.log.info("Expiring storage provider connection!  Storage account id: {}", (Object)storageAccountId);
        this.storageProviders.remove(storageAccountId);
    }
}

