/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.io.InputStream;
import java.text.MessageFormat;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.dbcp2.BasicDataSource;
import org.duracloud.audit.reader.AuditLogReader;
import org.duracloud.common.rest.RestUtil;
import org.duracloud.common.util.InitUtil;
import org.duracloud.durastore.rest.BaseRest;
import org.duracloud.durastore.rest.ManifestRest;
import org.duracloud.storage.domain.AuditConfig;
import org.duracloud.storage.domain.DatabaseConfig;
import org.duracloud.storage.domain.DuraStoreInitConfig;
import org.duracloud.storage.util.InitConfigParser;
import org.duracloud.storage.util.StorageProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/init")
@Component
public class InitRest
extends BaseRest {
    private final Logger log = LoggerFactory.getLogger(InitRest.class);
    private StorageProviderFactory storageProviderFactory;
    private RestUtil restUtil;
    private AuditLogReader auditLogReader;
    private BasicDataSource datasource;
    private ManifestRest manifestRest;

    @Autowired
    public InitRest(StorageProviderFactory storageProviderFactory, RestUtil restUtil, BasicDataSource datasource, AuditLogReader auditLogReader, ManifestRest manifestRest) {
        this.storageProviderFactory = storageProviderFactory;
        this.restUtil = restUtil;
        this.datasource = datasource;
        this.auditLogReader = auditLogReader;
        this.manifestRest = manifestRest;
    }

    @POST
    public Response initialize() {
        String msg = "initializing DuraStore";
        RestUtil.RequestContent content = null;
        try {
            String instanceHost = this.request.getServerName();
            String instancePort = String.valueOf(this.request.getServerPort());
            this.log.info("Initializing DuraStore on host: " + instanceHost + " and port: " + instancePort);
            content = this.restUtil.getRequestContent(this.request, this.headers);
            DuraStoreInitConfig initConfig = InitConfigParser.parseInitXml((InputStream)content.getContentStream());
            this.storageProviderFactory.initialize(initConfig, instanceHost, instancePort);
            AuditConfig auditConfig = initConfig.getAuditConfig();
            this.auditLogReader.initialize(auditConfig);
            this.configureMillDatabase(initConfig);
            String responseText = "Initialization Successful";
            return this.responseOk(msg, responseText);
        }
        catch (Exception e) {
            return this.responseBad(msg, e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void configureMillDatabase(DuraStoreInitConfig initConfig) {
        boolean millDbConfigured;
        DatabaseConfig dbConfig = initConfig.getMillDbConfig();
        boolean bl = millDbConfigured = dbConfig != null && dbConfig.getHost() != null && dbConfig.getName() != null && dbConfig.getUsername() != null && dbConfig.getPassword() != null;
        if (millDbConfigured) {
            this.datasource.setUrl(MessageFormat.format("jdbc:mysql://{0}:{1}/{2}", dbConfig.getHost(), dbConfig.getPort() + "", dbConfig.getName()));
            this.datasource.setUsername(dbConfig.getUsername());
            this.datasource.setPassword(dbConfig.getPassword());
            this.datasource.setTestOnBorrow(true);
            this.datasource.setValidationQuery("SELECT 1");
        }
        this.manifestRest.setEnabled(millDbConfigured);
    }

    @GET
    public Response isInitialized() {
        String msg = "checking initialized";
        boolean initialized = this.storageProviderFactory.isInitialized();
        if (initialized) {
            String text = InitUtil.getInitializedText((String)"DuraStore");
            return this.responseOk(msg, text);
        }
        String text = InitUtil.getNotInitializedText((String)"DuraStore");
        return this.responseBad(msg, text, Response.Status.SERVICE_UNAVAILABLE);
    }

    private Response responseOk(String msg, String text) {
        this.log.debug(msg);
        return Response.ok((Object)text, (MediaType)TEXT_PLAIN).build();
    }

    private Response responseBad(String msg, Exception e, Response.Status status) {
        String text = e.getMessage() == null ? "null" : e.getMessage();
        return this.responseBad(msg, text, status);
    }

    private Response responseBad(String msg, String text, Response.Status status) {
        this.log.error("Error while " + msg + ": " + text);
        return Response.status((Response.Status)status).entity((Object)text).build();
    }
}

