/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.io.InputStream;
import java.util.List;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.duracloud.common.rest.RestUtil;
import org.duracloud.durastore.rest.BaseRest;
import org.duracloud.security.DuracloudUserDetailsService;
import org.duracloud.security.xml.SecurityUsersDocumentBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/security")
@Component
public class SecurityRest
extends BaseRest {
    private final Logger log = LoggerFactory.getLogger(SecurityRest.class);
    private DuracloudUserDetailsService userDetailsService;
    private RestUtil restUtil;

    @Autowired
    public SecurityRest(DuracloudUserDetailsService userDetailsService, RestUtil restUtil) {
        this.userDetailsService = userDetailsService;
        this.restUtil = restUtil;
    }

    @POST
    public Response initializeUsers() {
        RestUtil.RequestContent content = null;
        try {
            content = this.restUtil.getRequestContent(this.request, this.headers);
            List users = SecurityUsersDocumentBinding.createSecurityUsersFrom((InputStream)content.getContentStream());
            this.userDetailsService.setUsers(users);
            String responseText = "Initialization Successful\n";
            return Response.ok((Object)responseText, (MediaType)TEXT_PLAIN).build();
        }
        catch (Exception e) {
            this.log.error("Error: initializing users.", (Throwable)e);
            String entity = e.getMessage() == null ? "null" : e.getMessage();
            return Response.serverError().entity((Object)entity).build();
        }
    }
}

