/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.util;

import java.net.InetAddress;
import org.duracloud.account.db.repo.DuracloudMillRepo;
import org.duracloud.common.cache.AbstractAccountComponentCache;
import org.duracloud.common.event.AccountChangeEvent;
import org.duracloud.common.rest.DuraCloudRequestContextUtil;
import org.duracloud.common.sns.AccountChangeNotifier;
import org.duracloud.common.util.UserUtil;
import org.duracloud.durastore.util.AuditConfigBuilder;
import org.duracloud.durastore.util.StorageAccountManagerFactory;
import org.duracloud.durastore.util.StorageProviderFactoryImpl;
import org.duracloud.storage.domain.AuditConfig;
import org.duracloud.storage.domain.StorageAccountManager;
import org.duracloud.storage.provider.StatelessStorageProvider;
import org.duracloud.storage.util.StorageProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProviderFactoryCache
extends AbstractAccountComponentCache<StorageProviderFactory> {
    private StorageAccountManagerFactory storageAccountManagerFactory;
    private StatelessStorageProvider statelessStorageProvider;
    private UserUtil userUtil;
    private DuracloudMillRepo millRepo;
    private DuraCloudRequestContextUtil contextUtil;
    private AccountChangeNotifier notifier;
    private Logger log = LoggerFactory.getLogger(StorageProviderFactoryCache.class);

    public StorageProviderFactoryCache(StorageAccountManagerFactory storageAccountManagerFactory, StatelessStorageProvider statelessStorageProvider, UserUtil userUtil, DuracloudMillRepo millRepo, AccountChangeNotifier notifier, DuraCloudRequestContextUtil contextUtil) {
        this.storageAccountManagerFactory = storageAccountManagerFactory;
        this.statelessStorageProvider = statelessStorageProvider;
        this.userUtil = userUtil;
        this.millRepo = millRepo;
        this.contextUtil = contextUtil;
        this.notifier = notifier;
    }

    public void onEvent(AccountChangeEvent event) {
        String accountId = event.getAccountId();
        AccountChangeEvent.EventType eventType = event.getEventType();
        if (accountId != null) {
            if (eventType.equals((Object)AccountChangeEvent.EventType.STORAGE_PROVIDERS_CHANGED) || eventType.equals((Object)AccountChangeEvent.EventType.ACCOUNT_CHANGED) || this.isAnotherNode(event)) {
                this.remove(accountId);
            }
        } else if (eventType.equals((Object)AccountChangeEvent.EventType.ALL_ACCOUNTS_CHANGED)) {
            this.removeAll();
        }
    }

    private boolean isAnotherNode(AccountChangeEvent event) {
        if (event.getEventType().equals((Object)AccountChangeEvent.EventType.STORAGE_PROVIDER_CACHE_ON_NODE_CHANGED)) {
            try {
                String host = InetAddress.getLocalHost().getHostName();
                if (!host.equals(event.getSourceHost())) {
                    this.log.debug("This node {} is identical to the event source.", (Object)host);
                    return true;
                }
                this.log.debug("This node {} is different from event source.", (Object)host);
            }
            catch (Exception ex) {
                this.log.warn("failed to check host: " + ex.getMessage(), (Throwable)ex);
            }
        }
        return false;
    }

    protected StorageProviderFactory createInstance(String accountId) {
        StorageAccountManager storageAccountManager = this.storageAccountManagerFactory.createInstance();
        AuditConfig auditConfig = new AuditConfigBuilder(this.millRepo).build();
        StorageProviderFactoryImpl factory = new StorageProviderFactoryImpl(storageAccountManager, this.statelessStorageProvider, this.userUtil, this.contextUtil, this.notifier, auditConfig);
        return factory;
    }
}

