/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.aop;

import java.lang.reflect.Method;
import java.util.Map;
import org.duracloud.error.UnauthorizedException;
import org.duracloud.s3storageprovider.dto.GetUrlTaskParameters;
import org.duracloud.security.util.AuthorizationHelper;
import org.duracloud.storage.provider.TaskProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.core.Ordered;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class StreamingAccessAdvice
implements MethodBeforeAdvice,
Ordered {
    private Logger log = LoggerFactory.getLogger(StreamingAccessAdvice.class);
    private int order = 0;
    private AuthorizationHelper authHelper;

    public StreamingAccessAdvice(AuthorizationHelper authHelper) {
        this.authHelper = authHelper;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void before(Method method, Object[] args, Object target) throws Throwable {
        String taskName = (String)args[0];
        if (!taskName.matches("get-url") && !taskName.matches("get-signed-url")) {
            return;
        }
        TaskProvider taskProvider = (TaskProvider)target;
        String storeId = taskProvider.getStoreId();
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (this.authHelper.hasAdmin(auth)) {
            return;
        }
        String taskParams = (String)args[1];
        GetUrlTaskParameters params = GetUrlTaskParameters.deserialize((String)taskParams);
        String spaceId = params.getSpaceId();
        Map acls = this.authHelper.getSpaceACLs(storeId, spaceId);
        if (!this.authHelper.hasReadAccess(auth.getName(), acls) && !this.authHelper.groupsHaveReadAccess(auth, acls)) {
            this.log.error(auth.getName() + " is not authorized to view content in " + spaceId);
            throw new UnauthorizedException("You are not authorized to access space " + spaceId + ".");
        }
        this.log.debug("successfully authorized {} to view {}", (Object)auth.getName(), (Object)spaceId);
    }
}

