/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.durastore.rest.SpaceResource;
import org.duracloud.durastore.rest.StorageStatsResource;
import org.duracloud.mill.db.repo.JpaSpaceStatsRepo;
import org.duracloud.reportdata.storage.SpaceStatsDTO;
import org.duracloud.reportdata.storage.StoreStatsDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="storageStatsResource")
public class StorageStatsResource {
    protected static final Logger log = LoggerFactory.getLogger(SpaceResource.class);
    private JpaSpaceStatsRepo spaceStatsRepo;

    @Autowired
    public StorageStatsResource(JpaSpaceStatsRepo spaceStatsRepo) {
        this.spaceStatsRepo = spaceStatsRepo;
    }

    public List<SpaceStatsDTO> getSpaceStats(String accountId, String storeId, String spaceId, Date start, Date end, GroupBy groupBy) {
        String interval = this.getInterval(groupBy);
        List list = this.spaceStatsRepo.getByAccountIdAndStoreIdAndSpaceId(accountId, storeId, spaceId, start, end, interval);
        ArrayList<SpaceStatsDTO> dtos = new ArrayList<SpaceStatsDTO>(list.size());
        for (Object[] s : list) {
            dtos.add(new SpaceStatsDTO(new Date(((BigInteger)s[0]).longValue() * 1000L), s[1].toString(), s[2].toString(), s[3].toString(), ((BigDecimal)s[4]).longValue(), ((BigDecimal)s[5]).longValue()));
        }
        return dtos;
    }

    protected String getInterval(GroupBy groupBy) {
        if (groupBy == null) {
            groupBy = GroupBy.day;
        }
        if (groupBy.equals((Object)GroupBy.day)) {
            return "%Y-%m-%d";
        }
        if (groupBy.equals((Object)GroupBy.week)) {
            return "%Y-%u";
        }
        if (groupBy.equals((Object)GroupBy.month)) {
            return "%Y-%m";
        }
        throw new DuraCloudRuntimeException("No sql interval defined for groupBy param: " + groupBy);
    }

    public List<StoreStatsDTO> getStorageProviderStats(String account, String storeId, Date start, Date end, GroupBy groupBy) {
        String interval = this.getInterval(groupBy);
        List list = this.spaceStatsRepo.getByAccountIdAndStoreId(account, storeId, start, end, interval);
        ArrayList<StoreStatsDTO> dtos = new ArrayList<StoreStatsDTO>(list.size());
        for (Object[] s : list) {
            dtos.add(new StoreStatsDTO(new Date(((BigInteger)s[0]).longValue() * 1000L), s[1].toString(), s[2].toString(), ((BigDecimal)s[3]).longValue(), ((BigDecimal)s[4]).longValue()));
        }
        return dtos;
    }

    public List<SpaceStatsDTO> getStorageProviderByDay(String account, String storeId, Date date) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.setTimeInMillis(date.getTime());
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        Date start = c.getTime();
        c.setTimeInMillis(date.getTime());
        c.set(10, 23);
        c.set(12, 59);
        c.set(13, 59);
        Date end = c.getTime();
        List list = this.spaceStatsRepo.getByAccountIdAndStoreIdAndDay(account, storeId, start, end);
        ArrayList<SpaceStatsDTO> dtos = new ArrayList<SpaceStatsDTO>(list.size());
        for (Object[] s : list) {
            dtos.add(new SpaceStatsDTO(start, s[1].toString(), s[2].toString(), s[3].toString(), ((BigDecimal)s[4]).longValue(), ((BigDecimal)s[5]).longValue()));
        }
        return dtos;
    }
}

