/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.util;

import org.duracloud.common.cache.AbstractAccountComponentCache;
import org.duracloud.common.event.AccountChangeEvent;
import org.duracloud.common.rest.DuraCloudRequestContextUtil;
import org.duracloud.durastore.util.StorageAccountManagerFactory;
import org.duracloud.durastore.util.TaskProviderFactoryImpl;
import org.duracloud.mill.manifest.ManifestStore;
import org.duracloud.storage.domain.StorageAccountManager;
import org.duracloud.storage.provider.TaskProviderFactory;
import org.duracloud.storage.util.StorageProviderFactory;

public class TaskProviderFactoryCache
extends AbstractAccountComponentCache<TaskProviderFactory> {
    private StorageAccountManagerFactory storageAccountManagerFactory;
    private StorageProviderFactory storageProviderFactory;
    private ManifestStore manifestStore;
    private DuraCloudRequestContextUtil contextUtil;

    public TaskProviderFactoryCache(DuraCloudRequestContextUtil contextUtil, StorageAccountManagerFactory storageAccountManagerFactory, StorageProviderFactory storageProviderFactory, ManifestStore manifestStore) {
        this.contextUtil = contextUtil;
        this.storageAccountManagerFactory = storageAccountManagerFactory;
        this.storageProviderFactory = storageProviderFactory;
        this.manifestStore = manifestStore;
    }

    public void onEvent(AccountChangeEvent event) {
        String accountId = event.getAccountId();
        AccountChangeEvent.EventType eventType = event.getEventType();
        if (accountId != null) {
            if (eventType.equals((Object)AccountChangeEvent.EventType.STORAGE_PROVIDERS_CHANGED) || eventType.equals((Object)AccountChangeEvent.EventType.ACCOUNT_CHANGED) || eventType.equals((Object)AccountChangeEvent.EventType.STORAGE_PROVIDER_CACHE_ON_NODE_CHANGED)) {
                this.remove(accountId);
            }
        } else if (eventType.equals((Object)AccountChangeEvent.EventType.ALL_ACCOUNTS_CHANGED)) {
            this.removeAll();
        }
    }

    public TaskProviderFactory getObject() throws Exception {
        return (TaskProviderFactory)this.get(this.contextUtil.getAccountId());
    }

    protected TaskProviderFactory createInstance(String accountId) {
        StorageAccountManager storageAccountManager = this.storageAccountManagerFactory.createInstance();
        return new TaskProviderFactoryImpl(storageAccountManager, this.storageProviderFactory, this.manifestStore);
    }
}

