/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.GlobalProperties;
import org.duracloud.account.db.model.StorageProviderAccount;
import org.duracloud.account.db.repo.DuracloudAccountRepo;
import org.duracloud.account.db.repo.GlobalPropertiesRepo;
import org.duracloud.common.rest.DuraCloudRequestContextUtil;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.domain.StorageAccountManager;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.domain.impl.StorageAccountImpl;

public class StorageAccountManagerFactory {
    private DuracloudAccountRepo accountRepo;
    private GlobalPropertiesRepo globalPropertiesRepo;
    private DuraCloudRequestContextUtil contextUtil;

    public StorageAccountManagerFactory(DuracloudAccountRepo accountRepo, GlobalPropertiesRepo globalPropertiesRepo, DuraCloudRequestContextUtil contextUtil) {
        this.accountRepo = accountRepo;
        this.globalPropertiesRepo = globalPropertiesRepo;
        this.contextUtil = contextUtil;
    }

    public StorageAccountManager createInstance() {
        String accountId = this.contextUtil.getAccountId();
        AccountInfo info = this.accountRepo.findBySubdomain(accountId);
        LinkedList<StorageAccount> sps = new LinkedList<StorageAccount>();
        sps.add(this.createStorageAccount(info.getPrimaryStorageProviderAccount(), true));
        StorageAccountManager storageAccountManager = new StorageAccountManager();
        for (StorageProviderAccount spa : info.getSecondaryStorageProviderAccounts()) {
            sps.add(this.createStorageAccount(spa, false));
        }
        storageAccountManager.initialize(sps);
        storageAccountManager.setEnvironment(this.contextUtil.getHost(), this.contextUtil.getPort() + "", accountId);
        return storageAccountManager;
    }

    private StorageAccount createStorageAccount(StorageProviderAccount spa, boolean primary) {
        List propslist;
        StorageAccountImpl storageAccount = new StorageAccountImpl(spa.getId() + "", spa.getUsername(), spa.getPassword(), spa.getProviderType());
        storageAccount.setPrimary(primary);
        storageAccount.setOwnerId(null);
        Map props = spa.getProperties();
        if (props != null) {
            for (String key : props.keySet()) {
                storageAccount.setOption(key, (String)props.get(key));
            }
        }
        if ((propslist = this.globalPropertiesRepo.findAll()) != null && propslist.size() > 0) {
            GlobalProperties globalProps = (GlobalProperties)propslist.get(0);
            StorageProviderType spType = spa.getProviderType();
            if (spType.equals((Object)StorageProviderType.AMAZON_S3)) {
                storageAccount.setOption(StorageAccount.OPTS.CF_ACCOUNT_ID.name(), globalProps.getCloudFrontAccountId());
                storageAccount.setOption(StorageAccount.OPTS.CF_KEY_ID.name(), globalProps.getCloudFrontKeyId());
                storageAccount.setOption(StorageAccount.OPTS.CF_KEY_PATH.name(), globalProps.getCloudFrontKeyPath());
            }
        }
        return storageAccount;
    }
}

