/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.error;

import org.duracloud.common.error.DuraCloudCheckedException;

public class ResourceException
extends DuraCloudCheckedException {
    private static final String messageKeyNoContent = "duracloud.error.durastore.resource.nocontent";
    private static final String messageKeyContent = "duracloud.error.durastore.resource.content";

    public ResourceException(String message) {
        super(message);
    }

    public ResourceException(String message, Throwable t) {
        super(message, t);
    }

    public ResourceException(String task, String spaceId, Throwable t) {
        super(ResourceException.buildErrMsg(task, spaceId, t), t, messageKeyContent);
        this.setArgs(new String[]{task, spaceId, t.getMessage()});
    }

    public ResourceException(String task, String spaceId, String contentId, Throwable t) {
        super(ResourceException.buildErrMsg(task, spaceId, contentId, t), t, messageKeyContent);
        this.setArgs(new String[]{task, spaceId, contentId, t.getMessage()});
    }

    public ResourceException(String task, String srcSpaceId, String srcContentId, String destSpaceId, String destContentId, Throwable t) {
        super(ResourceException.buildErrMsg(task, srcSpaceId, srcContentId, destSpaceId, destContentId, t), t, messageKeyContent);
        this.setArgs(new String[]{task, srcSpaceId, srcContentId, destSpaceId, destContentId, t.getMessage()});
    }

    public ResourceException(String task, String srcStoreName, String srcSpaceId, String srcContentId, String destStoreName, String destSpaceId, String destContentId, Throwable t) {
        super(ResourceException.buildErrMsg(task, srcStoreName, srcSpaceId, srcContentId, destStoreName, destSpaceId, destContentId, t), t, messageKeyContent);
        this.setArgs(new String[]{task, srcSpaceId, srcContentId, destSpaceId, destContentId, t.getMessage()});
    }

    private static String buildErrMsg(String task, String spaceId, Throwable t) {
        StringBuilder errMsg = new StringBuilder();
        errMsg.append("Error attempting to ");
        errMsg.append(task);
        errMsg.append(" '");
        errMsg.append(spaceId);
        errMsg.append("' due to: ");
        errMsg.append(t.getMessage());
        return errMsg.toString();
    }

    private static String buildErrMsg(String task, String spaceId, String contentId, Throwable t) {
        StringBuilder errMsg = new StringBuilder();
        errMsg.append("Error attempting to ");
        errMsg.append(task);
        errMsg.append(" '");
        errMsg.append(contentId);
        errMsg.append("' in '");
        errMsg.append(spaceId);
        errMsg.append("' due to: ");
        errMsg.append(t.getMessage());
        return errMsg.toString();
    }

    private static String buildErrMsg(String task, String srcSpaceId, String srcContentId, String destSpaceId, String destContentId, Throwable t) {
        StringBuilder errMsg = new StringBuilder();
        errMsg.append("Error attempting to ");
        errMsg.append(task);
        errMsg.append(" '");
        errMsg.append(srcSpaceId);
        errMsg.append(" / ");
        errMsg.append(srcContentId);
        errMsg.append("' to '");
        errMsg.append(destSpaceId);
        errMsg.append(" / ");
        errMsg.append(destContentId);
        errMsg.append("' due to: ");
        errMsg.append(t.getMessage());
        return errMsg.toString();
    }

    private static String buildErrMsg(String task, String srcStoreId, String srcSpaceId, String srcContentId, String destStoreId, String destSpaceId, String destContentId, Throwable t) {
        StringBuilder errMsg = new StringBuilder();
        errMsg.append("Error attempting to ");
        errMsg.append(task);
        errMsg.append(" '");
        errMsg.append(srcStoreId);
        errMsg.append(" / ");
        errMsg.append(srcSpaceId);
        errMsg.append(" / ");
        errMsg.append(srcContentId);
        errMsg.append("' to '");
        errMsg.append(destStoreId);
        errMsg.append(" / ");
        errMsg.append(destSpaceId);
        errMsg.append(" / ");
        errMsg.append(destContentId);
        errMsg.append("' due to: ");
        errMsg.append(t.getMessage());
        return errMsg.toString();
    }
}

