/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.duracloud.durastore.rest.BaseRest;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.util.StorageProviderFactory;
import org.duracloud.storage.xml.StorageAccountsDocumentBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/stores")
@Component
public class StoreRest
extends BaseRest {
    private final Logger log = LoggerFactory.getLogger(StoreRest.class);
    private StorageProviderFactory storageProviderFactory;
    private StorageAccountsDocumentBinding documentBinding;

    @Autowired
    public StoreRest(StorageProviderFactory storageProviderFactory, StorageAccountsDocumentBinding documentBinding) {
        this.storageProviderFactory = storageProviderFactory;
        this.documentBinding = documentBinding;
    }

    @GET
    public Response getStores() {
        String msg = "getting stores.";
        try {
            return this.doGetStores(msg);
        }
        catch (StorageException se) {
            return this.responseBad(msg, (Exception)((Object)se));
        }
        catch (Exception e) {
            return this.responseBad(msg, e);
        }
    }

    private Response doGetStores(String msg) {
        List accts = this.storageProviderFactory.getStorageAccounts();
        boolean includeCredentials = false;
        boolean includeOptions = false;
        String xml = this.documentBinding.createXmlFrom((Collection)accts, includeCredentials, includeOptions);
        return this.responseOkXml(msg, xml);
    }

    private Response responseOkXml(String msg, String xml) {
        this.log.debug(msg);
        return Response.ok((Object)xml, (MediaType)APPLICATION_XML).build();
    }

    private Response responseBad(String msg, Exception e) {
        this.log.error("Error: " + msg, (Throwable)e);
        String entity = e.getMessage() == null ? "null" : e.getMessage();
        return Response.serverError().entity((Object)entity).build();
    }
}

