/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.io.InputStream;
import java.util.Map;
import org.duracloud.durastore.error.ResourceChecksumException;
import org.duracloud.durastore.error.ResourceException;
import org.duracloud.durastore.error.ResourceNotFoundException;
import org.duracloud.durastore.error.ResourceStateException;
import org.duracloud.durastore.rest.ContentResource;
import org.duracloud.storage.error.ChecksumMismatchException;
import org.duracloud.storage.error.InvalidIdException;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.error.StorageStateException;
import org.duracloud.storage.provider.BrokeredStorageProvider;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.util.IdUtil;
import org.duracloud.storage.util.StorageProviderFactory;
import org.duracloud.storage.util.StorageProviderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentResourceImpl
implements ContentResource {
    private static final Logger log = LoggerFactory.getLogger(ContentResource.class);
    private StorageProviderFactory storageProviderFactory;

    public ContentResourceImpl(StorageProviderFactory storageProviderFactory) {
        this.storageProviderFactory = storageProviderFactory;
    }

    public InputStream getContent(String spaceID, String contentID, String storeID) throws ResourceException {
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            return storage.getContent(spaceID, contentID);
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("get content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (StorageStateException e) {
            throw new ResourceStateException("get content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("get content", spaceID, contentID, (Throwable)e);
        }
    }

    public Map<String, String> getContentProperties(String spaceID, String contentID, String storeID) throws ResourceException {
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            return storage.getContentProperties(spaceID, contentID);
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("get properties for content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("get properties for content", spaceID, contentID, (Throwable)e);
        }
    }

    public void updateContentProperties(String spaceID, String contentID, String contentMimeType, Map<String, String> userProperties, String storeID) throws ResourceException {
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            if (userProperties != null) {
                storage.setContentProperties(spaceID, contentID, userProperties);
            }
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("update properties for content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (StorageStateException e) {
            throw new ResourceStateException("update properties for content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("update properties for content", spaceID, contentID, (Throwable)e);
        }
    }

    public String addContent(String spaceID, String contentID, InputStream content, String contentMimeType, Map<String, String> userProperties, long contentSize, String checksum, String storeID) throws ResourceException, InvalidIdException {
        IdUtil.validateContentId((String)contentID);
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            try {
                Map oldUserProperties = storage.getContentProperties(spaceID, contentID);
                if (userProperties != null) {
                    oldUserProperties.putAll(userProperties);
                    String oldMimetype = (String)oldUserProperties.remove("content-mimetype");
                    if (contentMimeType == null || contentMimeType.trim() == "") {
                        contentMimeType = oldMimetype;
                    }
                    oldUserProperties = StorageProviderUtil.removeCalculatedProperties((Map)oldUserProperties);
                }
                userProperties = oldUserProperties;
            }
            catch (NotFoundException ex) {
                // empty catch block
            }
            return storage.addContent(spaceID, contentID, contentMimeType, userProperties, contentSize, checksum, content);
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("add content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (ChecksumMismatchException e) {
            throw new ResourceChecksumException("add content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("add content", spaceID, contentID, (Throwable)e);
        }
    }

    public String copyContent(String srcStoreID, String srcSpaceID, String srcContentID, String destStoreID, String destSpaceID, String destContentID) throws ResourceException {
        BrokeredStorageProvider destProvider;
        BrokeredStorageProvider srcProvider = this.getStorageProvider(srcStoreID);
        if (srcProvider.equals(destProvider = this.getStorageProvider(destStoreID))) {
            return this.copyContent((StorageProvider)srcProvider, srcSpaceID, srcContentID, destSpaceID, destContentID, srcStoreID);
        }
        return this.copyContentBetweenStorageProviders(srcProvider, srcSpaceID, srcContentID, srcStoreID, destProvider, destSpaceID, destContentID, destStoreID);
    }

    private BrokeredStorageProvider getStorageProvider(String storeID) {
        return (BrokeredStorageProvider)this.storageProviderFactory.getStorageProvider(storeID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String copyContentBetweenStorageProviders(BrokeredStorageProvider srcStorage, String srcSpaceID, String srcContentID, String srcStoreID, BrokeredStorageProvider destStorage, String destSpaceID, String destContentID, String destStoreID) throws ResourceException {
        try (InputStream inputStream = srcStorage.getContent(srcSpaceID, srcContentID);){
            String md5;
            Map properties = srcStorage.getContentProperties(srcSpaceID, srcContentID);
            Long contentSize = null;
            try {
                String contentSizeString = (String)properties.get("content-size");
                if (contentSizeString != null) {
                    contentSize = Long.parseLong(contentSizeString);
                }
            }
            catch (NumberFormatException ex) {
                String msg = "content size could not be parsed: " + ex.getMessage();
                log.warn(msg, (Throwable)ex);
            }
            String string = md5 = destStorage.addContent(destSpaceID, destContentID, (String)properties.get("content-mimetype"), properties, contentSize.longValue(), (String)properties.get("content-checksum"), inputStream);
            return string;
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("copy content", srcStorage.getTargetType().name(), srcSpaceID, srcContentID, destStorage.getTargetType().name(), destSpaceID, destContentID, (Throwable)e);
        }
        catch (StorageStateException e) {
            throw new ResourceStateException("copy content", srcStorage.getTargetType().name(), srcSpaceID, srcContentID, destStorage.getTargetType().name(), destSpaceID, destContentID, (Throwable)e);
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(srcStoreID);
            this.storageProviderFactory.expireStorageProvider(destStoreID);
            throw new ResourceException("copy content", srcStorage.getTargetType().name(), srcSpaceID, srcContentID, destStorage.getTargetType().name(), destSpaceID, destContentID, (Throwable)e);
        }
    }

    private String copyContent(StorageProvider storage, String srcSpaceID, String srcContentID, String destSpaceID, String destContentID, String storeID) throws ResourceException {
        try {
            return storage.copyContent(srcSpaceID, srcContentID, destSpaceID, destContentID);
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("copy content", srcSpaceID, srcContentID, destSpaceID, destContentID, (Throwable)e);
        }
        catch (StorageStateException e) {
            throw new ResourceStateException("copy content", srcSpaceID, srcContentID, destSpaceID, destContentID, (Throwable)e);
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("copy content", srcSpaceID, srcContentID, destSpaceID, destContentID, (Throwable)e);
        }
    }

    public void deleteContent(String spaceID, String contentID, String storeID) throws ResourceException {
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            storage.deleteContent(spaceID, contentID);
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("delete content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("delete content", spaceID, contentID, (Throwable)e);
        }
    }
}

