/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.util.DateUtil;
import org.duracloud.durastore.rest.BaseRest;
import org.duracloud.mill.db.model.BitIntegrityReport;
import org.duracloud.mill.db.repo.JpaBitIntegrityReportRepo;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.util.StorageProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Path(value="/bit-integrity")
@Component
@Order(value=1)
public class BitIntegrityReportRest
extends BaseRest {
    private final Logger log = LoggerFactory.getLogger(BitIntegrityReportRest.class);
    private JpaBitIntegrityReportRepo repo;
    private StorageProviderFactory storageProviderFactory;

    @Autowired
    public BitIntegrityReportRest(JpaBitIntegrityReportRepo repo, StorageProviderFactory storageProviderFactory) {
        this.repo = repo;
        this.storageProviderFactory = storageProviderFactory;
        this.log.info("created: {}, {}.", (Object)this.repo, (Object)this.storageProviderFactory);
    }

    @Path(value="/{spaceId}")
    @GET
    public Response getReport(@PathParam(value="spaceId") String spaceId, @QueryParam(value="storeID") String storeId) {
        this.log.debug("getting report for {} , {} ", (Object)spaceId, (Object)storeId);
        return this.getReport(spaceId, storeId, false);
    }

    @Path(value="/{spaceId}")
    @HEAD
    public Response getReportHead(@PathParam(value="spaceId") String spaceId, @QueryParam(value="storeID") String storeId) {
        this.log.debug("getting report head for {} , {} ", (Object)spaceId, (Object)storeId);
        return this.getReport(spaceId, storeId, true);
    }

    private Response getReport(String spaceId, String storeId, boolean headOnly) {
        String account = this.getSubdomain();
        this.log.info("getting bit integrity report log for account:{}, storeId:{}, spaceId:{}", new Object[]{account, storeId, spaceId});
        if (StringUtils.isBlank((CharSequence)storeId)) {
            for (StorageAccount storageAccount : this.storageProviderFactory.getStorageAccounts()) {
                if (!storageAccount.isPrimary()) continue;
                storeId = storageAccount.getId();
                break;
            }
            if (StringUtils.isBlank((CharSequence)storeId)) {
                throw new DuraCloudRuntimeException("storeId is blank and no primary storage account is indicated.");
            }
        }
        try {
            Response.ResponseBuilder responseBuilder;
            PageRequest pageRequest = new PageRequest(0, 1);
            Page page = this.repo.findByStoreIdAndSpaceIdAndDisplayTrueOrderByCompletionDateDesc(storeId, spaceId, (Pageable)pageRequest);
            if (page == null || CollectionUtils.isEmpty((Collection)page.getContent())) {
                StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeId);
                try {
                    storage.getSpaceACLs(spaceId);
                }
                catch (NotFoundException e) {
                    return this.responseNotFound("Space with ID " + spaceId + " does not exist");
                }
                return this.responseBad("No reports matching the criteria found.", Response.Status.NO_CONTENT);
            }
            BitIntegrityReport report = (BitIntegrityReport)page.getContent().get(0);
            StorageProvider provider = this.storageProviderFactory.getStorageProvider();
            String reportSpaceId = report.getReportSpaceId();
            String reportContentId = report.getReportContentId();
            Map props = provider.getContentProperties(reportSpaceId, reportContentId);
            String contentLength = (String)props.get("content-size");
            if (headOnly) {
                responseBuilder = Response.ok();
            } else {
                InputStream is = provider.getContent(reportSpaceId, reportContentId);
                responseBuilder = Response.ok((Object)is);
            }
            responseBuilder.header("Bit-Integrity-Report-Result", (Object)report.getResult().name());
            responseBuilder.header("Bit-Integrity-Report-Completion-Date", (Object)DateUtil.convertToString((long)report.getCompletionDate().getTime()));
            responseBuilder.header("Content-Length", (Object)contentLength);
            return responseBuilder.build();
        }
        catch (Exception e) {
            this.log.error(MessageFormat.format("Error for  account:{0}, storeId:{1}, spaceId:{2} -> {3}", account, storeId, spaceId, e.getMessage()));
            return this.responseBad(e);
        }
    }
}

