/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.duracloud.common.error.NoUserLoggedInException;
import org.duracloud.common.model.AclType;
import org.duracloud.common.model.Credential;
import org.duracloud.durastore.error.ResourceException;
import org.duracloud.durastore.error.ResourceNotFoundException;
import org.duracloud.durastore.rest.BaseRest;
import org.duracloud.durastore.rest.SpaceResource;
import org.duracloud.security.context.SecurityContextUtil;
import org.duracloud.storage.error.InvalidIdException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/")
@Component
public class SpaceRest
extends BaseRest {
    private final Logger log = LoggerFactory.getLogger(SpaceRest.class);
    private SpaceResource spaceResource;
    private SecurityContextUtil securityContextUtil;

    @Autowired
    public SpaceRest(SpaceResource spaceResource, SecurityContextUtil securityContextUtil) {
        this.spaceResource = spaceResource;
        this.securityContextUtil = securityContextUtil;
    }

    @Path(value="/spaces")
    @GET
    @Produces(value={"application/xml"})
    public Response getSpaces(@QueryParam(value="storeID") String storeID) {
        String msg = "getting spaces(" + storeID + ")";
        try {
            String xml = this.spaceResource.getSpaces(storeID);
            return this.responseOkXml(msg, xml);
        }
        catch (ResourceException e) {
            return this.responseBad(msg, (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            return this.responseBad(msg, e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Path(value="/{spaceID}")
    @GET
    @Produces(value={"application/xml"})
    public Response getSpace(@PathParam(value="spaceID") String spaceID, @QueryParam(value="storeID") String storeID, @QueryParam(value="prefix") String prefix, @QueryParam(value="maxResults") long maxResults, @QueryParam(value="marker") String marker) {
        StringBuilder msg = new StringBuilder("getting space contents(");
        msg.append(spaceID);
        msg.append(", ");
        msg.append(storeID);
        msg.append(", ");
        msg.append(prefix);
        msg.append(", ");
        msg.append(maxResults);
        msg.append(", ");
        msg.append(marker);
        msg.append(")");
        try {
            this.log.debug(msg.toString());
            return this.doGetSpace(spaceID, storeID, prefix, maxResults, marker);
        }
        catch (ResourceNotFoundException e) {
            return this.responseNotFound(msg.toString(), (Exception)((Object)e), Response.Status.NOT_FOUND);
        }
        catch (ResourceException e) {
            return this.responseBad(msg.toString(), (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            return this.responseBad(msg.toString(), e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response doGetSpace(String spaceID, String storeID, String prefix, long maxResults, String marker) throws ResourceException {
        String xml = this.spaceResource.getSpaceContents(spaceID, storeID, prefix, maxResults, marker);
        return this.addSpacePropertiesToResponse(Response.ok((Object)xml, (MediaType)APPLICATION_XML), spaceID, storeID);
    }

    @Path(value="/{spaceID}")
    @HEAD
    public Response getSpaceProperties(@PathParam(value="spaceID") String spaceID, @QueryParam(value="storeID") String storeID) {
        String msg = "adding space properties(" + spaceID + ", " + storeID + ")";
        try {
            this.log.debug(msg);
            return this.addSpacePropertiesToResponse(Response.ok(), spaceID, storeID);
        }
        catch (ResourceNotFoundException e) {
            return this.responseNotFound(msg, (Exception)((Object)e), Response.Status.NOT_FOUND);
        }
        catch (ResourceException e) {
            return this.responseBad(msg, (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            return this.responseBad(msg, e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response addSpacePropertiesToResponse(Response.ResponseBuilder response, String spaceID, String storeID) throws ResourceException {
        Map properties = this.spaceResource.getSpaceProperties(spaceID, storeID);
        return this.addPropertiesToResponse(response, properties);
    }

    private Response addPropertiesToResponse(Response.ResponseBuilder response, Map<String, String> properties) {
        for (String propName : properties.keySet()) {
            response.header("x-dura-meta-" + propName, (Object)properties.get(propName));
        }
        return response.build();
    }

    @Path(value="/acl/{spaceID}")
    @HEAD
    public Response getSpaceACLs(@PathParam(value="spaceID") String spaceID, @QueryParam(value="storeID") String storeID) {
        String msg = "getting space ACLs(" + spaceID + ", " + storeID + ")";
        try {
            this.log.debug(msg);
            return this.addSpaceACLsToResponse(Response.ok(), spaceID, storeID);
        }
        catch (ResourceNotFoundException e) {
            return this.responseNotFound(msg, (Exception)((Object)e), Response.Status.NOT_FOUND);
        }
        catch (ResourceException e) {
            return this.responseBad(msg, (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            return this.responseBad(msg, e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response addSpaceACLsToResponse(Response.ResponseBuilder response, String spaceID, String storeID) throws ResourceException {
        HashMap<String, String> aclProps = new HashMap<String, String>();
        Map acls = this.spaceResource.getSpaceACLs(spaceID, storeID);
        for (String key : acls.keySet()) {
            aclProps.put(key, ((AclType)acls.get(key)).name());
        }
        return this.addPropertiesToResponse(response, aclProps);
    }

    @Path(value="/{spaceID}")
    @PUT
    public Response addSpace(@PathParam(value="spaceID") String spaceID, @QueryParam(value="storeID") String storeID) {
        String msg = "adding space(" + spaceID + ", " + storeID + ")";
        try {
            this.log.debug(msg);
            return this.doAddSpace(spaceID, storeID);
        }
        catch (InvalidIdException e) {
            return this.responseBad(msg, (Exception)((Object)e), Response.Status.BAD_REQUEST);
        }
        catch (ResourceException e) {
            return this.responseBad(msg, (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            return this.responseBad(msg, e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response doAddSpace(String spaceID, String storeID) throws ResourceException, InvalidIdException {
        Map userACLs = this.getUserACLs();
        this.spaceResource.addSpace(spaceID, userACLs, storeID);
        URI location = this.uriInfo.getRequestUri();
        return Response.created((URI)location).build();
    }

    private Map<String, AclType> getUserACLs() {
        HashMap<String, AclType> acls = new HashMap<String, AclType>();
        try {
            Credential currentUser = this.securityContextUtil.getCurrentUser();
            acls.put("acl-" + currentUser.getUsername(), AclType.WRITE);
        }
        catch (NoUserLoggedInException e) {
            this.log.warn("Adding user acl, error: {}", (Throwable)e);
        }
        return acls;
    }

    @Path(value="/acl/{spaceID}")
    @POST
    public Response updateSpaceACLs(@PathParam(value="spaceID") String spaceID, @QueryParam(value="storeID") String storeID) {
        String msg = "update space ACLs(" + spaceID + ", " + storeID + ")";
        try {
            this.log.debug(msg);
            return this.doUpdateSpaceACLs(spaceID, storeID);
        }
        catch (ResourceNotFoundException e) {
            return this.responseNotFound(msg, (Exception)((Object)e), Response.Status.NOT_FOUND);
        }
        catch (ResourceException e) {
            return this.responseBad(msg, (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            return this.responseBad(msg, e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response doUpdateSpaceACLs(String spaceID, String storeID) throws ResourceException {
        Map spaceACLs = this.getSpaceACLs();
        this.spaceResource.updateSpaceACLs(spaceID, spaceACLs, storeID);
        String responseText = "Space " + spaceID + " ACLs updated successfully";
        return Response.ok((Object)responseText, (MediaType)TEXT_PLAIN).build();
    }

    @Path(value="/{spaceID}")
    @DELETE
    public Response deleteSpace(@PathParam(value="spaceID") String spaceID, @QueryParam(value="storeID") String storeID) {
        String msg = "deleting space(" + spaceID + ", " + storeID + ")";
        try {
            this.log.debug(msg);
            return this.doDeleteSpace(spaceID, storeID);
        }
        catch (ResourceNotFoundException e) {
            return this.responseNotFound(msg, (Exception)((Object)e), Response.Status.NOT_FOUND);
        }
        catch (ResourceException e) {
            return this.responseBad(msg, (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            return this.responseBad(msg, e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response doDeleteSpace(String spaceID, String storeID) throws ResourceException {
        this.spaceResource.deleteSpace(spaceID, storeID);
        String responseText = "Space " + spaceID + " deleted successfully";
        return Response.ok((Object)responseText, (MediaType)TEXT_PLAIN).build();
    }

    private Response responseOkXml(String msg, String text) {
        this.log.debug(msg);
        return Response.ok((Object)text, (MediaType)APPLICATION_XML).build();
    }

    private Response responseNotFound(String msg, Exception e, Response.Status status) {
        this.log.debug("Not Found: " + msg);
        return this.responseBad(e.getMessage(), status);
    }

    private Response responseBad(String msg, Exception e, Response.Status status) {
        this.log.error("Error: " + msg, (Throwable)e);
        return this.responseBad(e.getMessage(), status);
    }
}

