/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.duracloud.common.model.AclType;
import org.duracloud.durastore.error.ResourceException;
import org.duracloud.durastore.error.ResourceNotFoundException;
import org.duracloud.storage.error.InvalidIdException;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.util.IdUtil;
import org.duracloud.storage.util.StorageProviderFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceResource {
    protected static final Logger log = LoggerFactory.getLogger(SpaceResource.class);
    private StorageProviderFactory storageProviderFactory;

    public SpaceResource(StorageProviderFactory storageProviderFactory) {
        this.storageProviderFactory = storageProviderFactory;
    }

    public String getSpaces(String storeID) throws ResourceException {
        log.debug("Enter");
        Element spacesElem = new Element("spaces");
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            Iterator spaces = storage.getSpaces();
            while (spaces.hasNext()) {
                String spaceID = (String)spaces.next();
                Element spaceElem = new Element("space");
                spaceElem.setAttribute("id", spaceID);
                spacesElem.addContent((Content)spaceElem);
            }
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("Error attempting to build spaces XML", (Throwable)e);
        }
        Document doc = new Document(spacesElem);
        XMLOutputter xmlConverter = new XMLOutputter();
        return xmlConverter.outputString(doc);
    }

    public Map<String, String> getSpaceProperties(String spaceID, String storeID) throws ResourceException {
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            return storage.getSpaceProperties(spaceID);
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("retrieve space properties for", spaceID, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("retrieve space properties for", spaceID, (Throwable)e);
        }
    }

    public Map<String, AclType> getSpaceACLs(String spaceID, String storeID) throws ResourceException {
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            return storage.getSpaceACLs(spaceID);
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("retrieve space ACLs for", spaceID, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("retrieve space ACLs for", spaceID, (Throwable)e);
        }
    }

    public String getSpaceContents(String spaceID, String storeID, String prefix, long maxResults, String marker) throws ResourceException {
        Element spaceElem = new Element("space");
        spaceElem.setAttribute("id", spaceID);
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            List contents = storage.getSpaceContentsChunked(spaceID, prefix, maxResults, marker);
            if (contents != null) {
                for (String contentItem : contents) {
                    Element contentElem = new Element("item");
                    contentElem.setText(contentItem);
                    spaceElem.addContent((Content)contentElem);
                }
            }
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("build space XML for", spaceID, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("build space XML for", spaceID, (Throwable)e);
        }
        Document doc = new Document(spaceElem);
        XMLOutputter xmlConverter = new XMLOutputter();
        return xmlConverter.outputString(doc);
    }

    public void addSpace(String spaceID, Map<String, AclType> userACLs, String storeID) throws ResourceException, InvalidIdException {
        IdUtil.validateSpaceId((String)spaceID);
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            storage.createSpace(spaceID);
            this.waitForSpaceCreation(storage, spaceID);
            this.updateSpaceACLs(spaceID, userACLs, storeID);
        }
        catch (NotFoundException e) {
            throw new InvalidIdException(e.getMessage());
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("add space", spaceID, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSpaceCreation(StorageProvider storage, String spaceID) {
        int maxTries = 10;
        int tries = 0;
        long millis = 1500L;
        while (tries < maxTries) {
            ++tries;
            try {
                storage.getSpaceACLs(spaceID);
                return;
            }
            catch (Exception exception) {}
            continue;
            finally {
                this.sleep(millis);
            }
        }
        long elapsed = millis * (long)maxTries;
        String msg = "Space " + spaceID + " !created in " + elapsed + " millis";
        log.error(msg);
        throw new StorageException(msg);
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void updateSpaceACLs(String spaceID, Map<String, AclType> spaceACLs, String storeID) throws ResourceException {
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            if (null != spaceACLs) {
                storage.setSpaceACLs(spaceID, spaceACLs);
            }
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("update space ACLs for", spaceID, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("update space ACLs for", spaceID, (Throwable)e);
        }
    }

    public void deleteSpace(String spaceID, String storeID) throws ResourceException {
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            storage.deleteSpace(spaceID);
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("delete space", spaceID, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("delete space", spaceID, (Throwable)e);
        }
    }
}

