/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.duracloud.audit.logger.ClientInfoLogger;
import org.duracloud.common.rest.RestUtil;
import org.duracloud.common.web.EncodeUtil;
import org.duracloud.durastore.error.ResourceChecksumException;
import org.duracloud.durastore.error.ResourceException;
import org.duracloud.durastore.error.ResourceNotFoundException;
import org.duracloud.durastore.error.ResourceStateException;
import org.duracloud.durastore.rest.BaseRest;
import org.duracloud.durastore.rest.ContentResource;
import org.duracloud.storage.error.InvalidIdException;
import org.duracloud.storage.error.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/{spaceID: (?!acl/)[^/]+}/{contentID: [^?]+}")
@Component
public class ContentRest
extends BaseRest {
    private final Logger log = LoggerFactory.getLogger(ContentRest.class);
    private ContentResource contentResource;
    private RestUtil restUtil;
    private final ClientInfoLogger clientInfoLog = new ClientInfoLogger();

    @Autowired
    public ContentRest(ContentResource contentResource, RestUtil restUtil) {
        this.contentResource = contentResource;
        this.restUtil = restUtil;
    }

    @GET
    public Response getContent(@PathParam(value="spaceID") String spaceID, @PathParam(value="contentID") String contentID, @QueryParam(value="storeID") String storeID, @QueryParam(value="attachment") boolean attachment) {
        StringBuilder msg = new StringBuilder("getting content(");
        msg.append(spaceID);
        msg.append(", ");
        msg.append(contentID);
        msg.append(", ");
        msg.append(storeID);
        msg.append(", ");
        msg.append(attachment);
        msg.append(")");
        try {
            this.log.debug(msg.toString());
            return this.doGetContent(spaceID, contentID, storeID, attachment);
        }
        catch (ResourceNotFoundException e) {
            return this.responseNotFound(msg.toString(), (Exception)((Object)e), Response.Status.NOT_FOUND);
        }
        catch (ResourceStateException e) {
            return this.responseBad(msg.toString(), (Exception)((Object)e), Response.Status.CONFLICT);
        }
        catch (ResourceException e) {
            return this.responseBad(msg.toString(), (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            return this.responseBad(msg.toString(), e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response doGetContent(String spaceID, String contentID, String storeID, boolean attachment) throws ResourceException {
        Map<String, String> properties = this.contentResource.getContentProperties(spaceID, contentID, storeID);
        AutoCloseInputStream content = new AutoCloseInputStream(this.contentResource.getContent(spaceID, contentID, storeID));
        Response.ResponseBuilder responseBuilder = Response.ok((Object)content);
        if (attachment) {
            this.addContentDispositionHeader(responseBuilder, contentID);
        }
        return this.addContentPropertiesToResponse(responseBuilder, properties);
    }

    private void addContentDispositionHeader(Response.ResponseBuilder responseBuilder, String filename) {
        StringBuffer contentDisposition = new StringBuffer();
        contentDisposition.append("attachment;");
        contentDisposition.append("filename=\"");
        contentDisposition.append(filename);
        contentDisposition.append("\"");
        responseBuilder.header("Content-Disposition", (Object)contentDisposition.toString());
    }

    @HEAD
    public Response getContentProperties(@PathParam(value="spaceID") String spaceID, @PathParam(value="contentID") String contentID, @QueryParam(value="storeID") String storeID) {
        StringBuilder msg = new StringBuilder("getting content properties(");
        msg.append(spaceID);
        msg.append(", ");
        msg.append(contentID);
        msg.append(", ");
        msg.append(storeID);
        msg.append(")");
        try {
            Map<String, String> properties = this.contentResource.getContentProperties(spaceID, contentID, storeID);
            this.log.debug(msg.toString());
            return this.addContentPropertiesToResponse(Response.ok(), properties);
        }
        catch (ResourceNotFoundException e) {
            return this.responseNotFound(msg.toString(), (Exception)((Object)e), Response.Status.NOT_FOUND);
        }
        catch (ResourceException e) {
            return this.responseBad(msg.toString(), (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            return this.responseBad(msg.toString(), e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected Response addContentPropertiesToResponse(Response.ResponseBuilder response, Map<String, String> properties) {
        if (properties != null) {
            String contentMimetype = properties.remove("content-mimetype");
            String contentType = properties.remove("Content-Type");
            if (null != contentMimetype && this.validMimetype(contentMimetype)) {
                response.header("Content-Type", (Object)contentMimetype);
            } else if (null != contentType && this.validMimetype(contentType)) {
                response.header("Content-Type", (Object)contentType);
            } else {
                response.header("Content-Type", (Object)"application/octet-stream");
            }
            String contentSize = properties.remove("content-size");
            String contentLength = properties.remove("Content-Length");
            if (null != contentSize) {
                response.header("Content-Length", (Object)contentSize);
            } else if (null != contentLength) {
                response.header("Content-Length", (Object)contentLength);
            }
            String contentModified = properties.remove("content-modified");
            String lastModified = properties.remove("Last-Modified");
            if (null != contentModified) {
                response.header("Last-Modified", (Object)contentModified);
            } else if (null != lastModified) {
                response.header("Last-Modified", (Object)lastModified);
            }
            String contentChecksum = properties.remove("content-checksum");
            String contentMdFive = properties.remove("content-md5");
            String contentMd5 = properties.remove("Content-MD5");
            String etag = properties.remove("ETag");
            if (null != contentChecksum) {
                response.header("Content-MD5", (Object)contentChecksum);
                response.header("ETag", (Object)contentChecksum);
            } else if (null != contentMdFive) {
                response.header("Content-MD5", (Object)contentMdFive);
                response.header("ETag", (Object)contentMdFive);
            } else if (null != contentMd5) {
                response.header("Content-MD5", (Object)contentMd5);
                response.header("ETag", (Object)contentMd5);
            } else if (null != etag) {
                response.header("Content-MD5", (Object)etag);
                response.header("ETag", (Object)etag);
            }
            for (String propertiesName : properties.keySet()) {
                String propertiesValue = properties.get(propertiesName);
                if (propertiesName.equals("Date") || propertiesName.equals("Connection")) continue;
                if (propertiesName.equals("Age") || propertiesName.equals("Cache-Control") || propertiesName.equals("Content-Encoding") || propertiesName.equals("Content-Language") || propertiesName.equals("Content-Location") || propertiesName.equals("Content-Range") || propertiesName.equals("Expires") || propertiesName.equals("Location") || propertiesName.equals("Pragma") || propertiesName.equals("Retry-After") || propertiesName.equals("Server") || propertiesName.equals("Transfer-Encoding") || propertiesName.equals("Upgrade") || propertiesName.equals("Warning")) {
                    response.header(propertiesName, (Object)propertiesValue);
                    continue;
                }
                response.header("x-dura-meta-" + propertiesName, (Object)propertiesValue);
            }
        }
        return response.build();
    }

    protected boolean validMimetype(String mimetype) {
        boolean valid = true;
        if (mimetype == null || mimetype.equals("")) {
            valid = false;
        } else {
            try {
                MediaType.valueOf((String)mimetype);
            }
            catch (IllegalArgumentException e) {
                valid = false;
            }
        }
        return valid;
    }

    @POST
    public Response updateContentProperties(@PathParam(value="spaceID") String spaceID, @PathParam(value="contentID") String contentID, @QueryParam(value="storeID") String storeID) {
        StringBuilder msg = new StringBuilder("updating content properties(");
        msg.append(spaceID);
        msg.append(", ");
        msg.append(contentID);
        msg.append(", ");
        msg.append(storeID);
        msg.append(")");
        try {
            this.log.debug(msg.toString());
            return this.doUpdateContentProperties(spaceID, contentID, storeID);
        }
        catch (ResourceNotFoundException e) {
            return this.responseNotFound(msg.toString(), (Exception)((Object)e), Response.Status.NOT_FOUND);
        }
        catch (ResourceStateException e) {
            return this.responseBad(msg.toString(), (Exception)((Object)e), Response.Status.CONFLICT);
        }
        catch (ResourceException e) {
            return this.responseBad(msg.toString(), (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            return this.responseBad(msg.toString(), e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response doUpdateContentProperties(String spaceID, String contentID, String storeID) throws ResourceException {
        MultivaluedMap rHeaders = this.headers.getRequestHeaders();
        String contentMimeType = null;
        if (rHeaders.containsKey((Object)"x-dura-meta-content-mimetype")) {
            contentMimeType = (String)rHeaders.getFirst((Object)"x-dura-meta-content-mimetype");
        }
        if (contentMimeType == null && rHeaders.containsKey((Object)"Content-Type")) {
            contentMimeType = (String)rHeaders.getFirst((Object)"Content-Type");
        }
        this.contentResource.updateContentProperties(spaceID, contentID, contentMimeType, this.getProperties(contentMimeType), storeID);
        String responseText = "Content " + contentID + " updated successfully";
        return Response.ok((Object)responseText, (MediaType)TEXT_PLAIN).build();
    }

    private Map<String, String> getProperties(String contentMimeType) throws ResourceException {
        Map<String, String> userProperties = this.getUserProperties("x-dura-meta-content-mimetype");
        if (contentMimeType != null && !contentMimeType.equals("")) {
            if (this.validMimetype(contentMimeType)) {
                userProperties.put("content-mimetype", contentMimeType);
            } else {
                throw new ResourceException("Invalid Mimetype");
            }
        }
        return userProperties;
    }

    @PUT
    public Response putContent(@PathParam(value="spaceID") String spaceID, @PathParam(value="contentID") String contentID, @QueryParam(value="storeID") String storeID, @HeaderParam(value="x-dura-meta-copy-source") String copySource, @HeaderParam(value="x-dura-meta-copy-source-store") String sourceStoreID) {
        if (null != copySource) {
            return this.copyContent(spaceID, contentID, storeID, sourceStoreID, copySource);
        }
        return this.addContent(spaceID, contentID, storeID);
    }

    private Response addContent(String spaceID, String contentID, String storeID) {
        StringBuilder msg = new StringBuilder("adding content(");
        msg.append(spaceID);
        msg.append(", ");
        msg.append(contentID);
        msg.append(", ");
        msg.append(storeID);
        msg.append(")");
        try {
            this.log.info(msg.toString());
            return this.doAddContent(spaceID, contentID, storeID);
        }
        catch (InvalidIdException e) {
            return this.responseBad(msg.toString(), (Exception)((Object)e), Response.Status.BAD_REQUEST);
        }
        catch (ResourceNotFoundException e) {
            return this.responseNotFound(msg.toString(), (Exception)((Object)e), Response.Status.NOT_FOUND);
        }
        catch (ResourceChecksumException e) {
            return this.responseBad(msg.toString(), (Exception)((Object)e), Response.Status.CONFLICT);
        }
        catch (ResourceException e) {
            return this.responseBad(msg.toString(), (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            return this.responseBad(msg.toString(), e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response doAddContent(String spaceID, String contentID, String storeID) throws Exception {
        RestUtil.RequestContent content = this.restUtil.getRequestContent(this.request, this.headers);
        String checksum = null;
        MultivaluedMap rHeaders = this.headers.getRequestHeaders();
        this.logClientInfo((MultivaluedMap<String, String>)rHeaders);
        if (rHeaders.containsKey((Object)"Content-MD5")) {
            checksum = (String)rHeaders.getFirst((Object)"Content-MD5");
        }
        if (content != null) {
            checksum = this.contentResource.addContent(spaceID, contentID, content.getContentStream(), content.getMimeType(), this.getProperties(content.getMimeType()), content.getSize(), checksum, storeID);
            URI location = this.uriInfo.getRequestUri();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("content-checksum", checksum);
            return this.addContentPropertiesToResponse(Response.created((URI)location), properties);
        }
        String error = "Content could not be retrieved from the request.";
        this.log.error(error);
        return Response.status((int)400).entity((Object)error).build();
    }

    private void logClientInfo(MultivaluedMap<String, String> rHeaders) {
        HashMap<String, String> clientInfo = new HashMap<String, String>();
        clientInfo.put("accountId", this.getAccountId());
        clientInfo.put("clientVersion", rHeaders.containsKey((Object)"x-dura-client-version") ? (String)rHeaders.getFirst((Object)"x-dura-client-version") : "none-specified");
        this.clientInfoLog.log(clientInfo);
    }

    private Response copyContent(String spaceID, String contentID, String storeID, String sourceStoreID, String copySource) {
        StringBuilder msg = new StringBuilder("copying content from (");
        msg.append(copySource);
        msg.append(") to (");
        msg.append(spaceID);
        msg.append(" / ");
        msg.append(contentID);
        msg.append(", ");
        msg.append(storeID);
        msg.append(")");
        this.log.info(msg.toString());
        try {
            return this.doCopyContent(spaceID, contentID, storeID, sourceStoreID, copySource);
        }
        catch (InvalidIdException e) {
            return this.responseBad(msg.toString(), (Exception)((Object)e), Response.Status.BAD_REQUEST);
        }
        catch (InvalidRequestException e) {
            return this.responseBad(msg.toString(), (Exception)((Object)e), Response.Status.BAD_REQUEST);
        }
        catch (ResourceNotFoundException e) {
            return this.responseNotFound(msg.toString(), (Exception)((Object)e), Response.Status.NOT_FOUND);
        }
        catch (ResourceStateException e) {
            return this.responseBad(msg.toString(), (Exception)((Object)e), Response.Status.CONFLICT);
        }
        catch (ResourceException e) {
            return this.responseBad(msg.toString(), (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            return this.responseBad(msg.toString(), e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response doCopyContent(String destSpaceID, String destContentID, String storeID, String sourceStoreID, String copySource) throws Exception {
        StringBuilder msg = new StringBuilder();
        RestUtil.RequestContent content = this.restUtil.getRequestContent(this.request, this.headers);
        if (null != content && content.getSize() > 0L) {
            msg.append("Body should not be present in copy-content request:");
            msg.append(" from ");
            msg.append(copySource);
            msg.append(", with body size: ");
            msg.append(content.getSize());
            this.log.error(msg.toString());
            throw new InvalidRequestException(msg.toString());
        }
        if (null == copySource || copySource.isEmpty()) {
            msg.append("Missing header: ");
            msg.append("x-dura-meta-copy-source");
            this.log.error(msg.toString());
            throw new InvalidRequestException(msg.toString());
        }
        String srcSpaceID = this.getSpaceId(copySource);
        String srcContentID = EncodeUtil.urlDecode((String)this.getContentId(copySource));
        if (null == srcSpaceID || null == srcContentID) {
            msg.append("Malformed ");
            msg.append("x-dura-meta-copy-source");
            msg.append(" header: ");
            msg.append(copySource);
            this.log.error(msg.toString());
            throw new InvalidRequestException(msg.toString());
        }
        msg.append("copying content from (store[");
        msg.append(sourceStoreID);
        msg.append("]: ");
        msg.append(srcSpaceID);
        msg.append(" / ");
        msg.append(srcContentID);
        msg.append(")");
        this.log.info(msg.toString());
        String checksum = this.contentResource.copyContent(sourceStoreID, srcSpaceID, srcContentID, storeID, destSpaceID, destContentID);
        URI location = this.uriInfo.getRequestUri();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("content-checksum", checksum);
        return this.addContentPropertiesToResponse(Response.created((URI)location), properties);
    }

    private String getSpaceId(String copySource) {
        String[] spaceAndContent = this.splitSpaceAndContentIds(copySource);
        return null == spaceAndContent ? null : spaceAndContent[0];
    }

    private String getContentId(String copySource) {
        String[] spaceAndContent = this.splitSpaceAndContentIds(copySource);
        return null == spaceAndContent ? null : spaceAndContent[1];
    }

    private String[] splitSpaceAndContentIds(String copySource) {
        if (null == copySource || copySource.isEmpty()) {
            return null;
        }
        while (copySource.charAt(0) == '/') {
            copySource = copySource.substring(1, copySource.length());
        }
        int contentStartIndex = copySource.indexOf("/");
        if (-1 == contentStartIndex || contentStartIndex == copySource.length() - 1) {
            return null;
        }
        String[] spaceAndContent = new String[]{copySource.substring(0, contentStartIndex), copySource.substring(contentStartIndex + 1, copySource.length())};
        return spaceAndContent;
    }

    @DELETE
    public Response deleteContent(@PathParam(value="spaceID") String spaceID, @PathParam(value="contentID") String contentID, @QueryParam(value="storeID") String storeID) {
        StringBuilder msg = new StringBuilder("deleting content(");
        msg.append(spaceID);
        msg.append(", ");
        msg.append(contentID);
        msg.append(", ");
        msg.append(storeID);
        msg.append(")");
        try {
            this.contentResource.deleteContent(spaceID, contentID, storeID);
            String responseText = "Content " + contentID + " deleted successfully";
            return this.responseOk(msg.toString(), responseText);
        }
        catch (ResourceNotFoundException e) {
            return this.responseNotFound(msg.toString(), (Exception)((Object)e), Response.Status.NOT_FOUND);
        }
        catch (ResourceException e) {
            return this.responseBad(msg.toString(), (Exception)((Object)e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            return this.responseBad(msg.toString(), e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response responseOk(String msg, String text) {
        this.log.debug(msg);
        return Response.ok((Object)text, (MediaType)TEXT_PLAIN).build();
    }

    private Response responseNotFound(String msg, Exception e, Response.Status status) {
        this.log.debug("Not Found: " + msg);
        return this.responseBad(e.getMessage(), status);
    }

    private Response responseBad(String msg, Exception e, Response.Status status) {
        this.log.error("Error: " + msg, (Throwable)e);
        return this.responseBad(e.getMessage(), status);
    }
}

