/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.aop;

import java.lang.reflect.Method;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.StatelessStorageProvider;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.core.Ordered;

public class VerifySpaceDeletionAdvice
implements AfterReturningAdvice,
Ordered {
    private final Logger log = LoggerFactory.getLogger(VerifySpaceDeletionAdvice.class);
    private int maxRetries;
    private int waitTime;
    private int order;

    public void afterReturning(Object returnObj, Method method, Object[] methodArgs, Object targetObj) throws Throwable {
        boolean spaceExists = true;
        int numAttempts = 0;
        StatelessStorageProvider provider = (StatelessStorageProvider)targetObj;
        StorageProvider target = (StorageProvider)methodArgs[0];
        String storeId = (String)methodArgs[1];
        String spaceId = (String)methodArgs[2];
        do {
            ++numAttempts;
            try {
                provider.getSpaceProperties(target, storeId, spaceId);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Attempt " + numAttempts + " to verify that space " + spaceId + " is no longer available after deletion failed.");
                }
                Thread.sleep(this.waitTime);
            }
            catch (StorageException se) {
                spaceExists = false;
            }
        } while (spaceExists && numAttempts <= this.maxRetries);
        if (spaceExists) {
            String error = "Unable to verify deletion of space " + spaceId + " after " + this.maxRetries + " attempts.";
            throw new StorageException(error, true);
        }
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

