/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.io.InputStream;
import org.duracloud.common.constant.ManifestFormat;
import org.duracloud.manifest.ManifestGenerator;
import org.duracloud.manifest.error.ManifestArgumentException;
import org.duracloud.manifest.error.ManifestNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestResource {
    private final Logger log = LoggerFactory.getLogger(ManifestResource.class);
    private ManifestGenerator manifestGenerator;

    public ManifestResource(ManifestGenerator manifestGenerator) {
        this.manifestGenerator = manifestGenerator;
    }

    public InputStream getManifest(String account, String storeId, String spaceId, String fmt) throws ManifestArgumentException, ManifestNotFoundException {
        return this.manifestGenerator.getManifest(account, storeId, spaceId, this.validateFormat(fmt));
    }

    private ManifestFormat validateFormat(String format) throws ManifestArgumentException {
        if (null == format) {
            return ManifestFormat.TSV;
        }
        try {
            return ManifestFormat.valueOf((String)format.toUpperCase());
        }
        catch (RuntimeException e) {
            StringBuilder err = new StringBuilder("Invalid manifest format: ");
            err.append(format);
            err.append(" Allowable formats are: '");
            for (ManifestFormat f : ManifestFormat.values()) {
                err.append(f.name());
                err.append("', '");
            }
            err.delete(err.length() - 3, err.length());
            this.log.error(err.toString());
            throw new ManifestArgumentException(err.toString());
        }
    }
}

