/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.duracloud.audit.provider.AuditStorageProvider;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.common.queue.aws.SQSTaskQueue;
import org.duracloud.common.queue.noop.NoopTaskQueue;
import org.duracloud.common.rest.DuraCloudRequestContextUtil;
import org.duracloud.common.sns.AccountChangeNotifier;
import org.duracloud.common.util.UserUtil;
import org.duracloud.durastore.test.MockRetryStorageProvider;
import org.duracloud.durastore.test.MockVerifyCreateStorageProvider;
import org.duracloud.durastore.test.MockVerifyDeleteStorageProvider;
import org.duracloud.durastore.util.ACLStorageProvider;
import org.duracloud.durastore.util.ProviderFactoryBase;
import org.duracloud.glacierstorage.GlacierStorageProvider;
import org.duracloud.irodsstorage.IrodsStorageProvider;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.snapshotstorage.ChronopolisStorageProvider;
import org.duracloud.storage.domain.AuditConfig;
import org.duracloud.storage.domain.DuraStoreInitConfig;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.domain.StorageAccountManager;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.BrokeredStorageProvider;
import org.duracloud.storage.provider.StatelessStorageProvider;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.provider.StorageProviderBase;
import org.duracloud.storage.util.StorageProviderFactory;
import org.duracloud.swiftstorage.SwiftStorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProviderFactoryImpl
extends ProviderFactoryBase
implements StorageProviderFactory {
    private Logger log = LoggerFactory.getLogger(StorageProviderFactoryImpl.class);
    private StatelessStorageProvider statelessProvider;
    private Map<String, StorageProvider> storageProviders;
    private UserUtil userUtil;
    private TaskQueue auditQueue;
    private boolean cacheStorageProvidersOnInit = false;
    private DuraCloudRequestContextUtil contextUtil;
    private AccountChangeNotifier notifier;

    public StorageProviderFactoryImpl(StorageAccountManager storageAccountManager, StatelessStorageProvider statelessStorageProvider, UserUtil userUtil, DuraCloudRequestContextUtil contextUtil, AccountChangeNotifier notifier) {
        this(storageAccountManager, statelessStorageProvider, userUtil, contextUtil, notifier, false);
    }

    public StorageProviderFactoryImpl(StorageAccountManager storageAccountManager, StatelessStorageProvider statelessStorageProvider, UserUtil userUtil, DuraCloudRequestContextUtil contextUtil, AccountChangeNotifier notifier, boolean cacheStorageProvidersOnInit) {
        super(storageAccountManager);
        this.statelessProvider = statelessStorageProvider;
        this.storageProviders = new ConcurrentHashMap<String, StorageProvider>();
        this.userUtil = userUtil;
        this.cacheStorageProvidersOnInit = cacheStorageProvidersOnInit;
        this.contextUtil = contextUtil;
        this.notifier = notifier;
    }

    public StorageProviderFactoryImpl(StorageAccountManager storageAccountManager, StatelessStorageProvider statelessStorageProvider, UserUtil userUtil, DuraCloudRequestContextUtil contextUtil, AccountChangeNotifier notifier, AuditConfig auditConfig) {
        this(storageAccountManager, statelessStorageProvider, userUtil, contextUtil, notifier);
        this.configureAuditQueue(auditConfig);
    }

    @Override
    public void initialize(DuraStoreInitConfig initConfig, String instanceHost, String instancePort, String accountId) throws StorageException {
        super.initialize(initConfig, instanceHost, instancePort, accountId);
        this.configureAuditQueue();
        this.initializeStorageProviders();
    }

    private void initializeStorageProviders() {
        this.storageProviders = new ConcurrentHashMap<String, StorageProvider>();
        if (this.cacheStorageProvidersOnInit) {
            this.log.info("Caching storage providers on init is enabled: building storage provider cache...");
            Iterator ids = this.getAccountManager().getStorageAccountIds();
            while (ids.hasNext()) {
                this.getStorageProvider((String)ids.next());
            }
        }
    }

    private void configureAuditQueue() {
        this.configureAuditQueue(this.getInitConfig().getAuditConfig());
    }

    private void configureAuditQueue(AuditConfig auditConfig) {
        String queueName;
        this.auditQueue = null == auditConfig ? new NoopTaskQueue() : (null == (queueName = auditConfig.getAuditQueueName()) ? new NoopTaskQueue() : new SQSTaskQueue(queueName));
    }

    public TaskQueue getAuditQueue() {
        return this.auditQueue;
    }

    public List<StorageAccount> getStorageAccounts() {
        ArrayList<StorageAccount> accts = new ArrayList<StorageAccount>();
        Iterator ids = this.getAccountManager().getStorageAccountIds();
        while (ids.hasNext()) {
            accts.add(this.getAccountManager().getStorageAccount((String)ids.next()));
        }
        return accts;
    }

    public StorageProvider getStorageProvider() throws StorageException {
        return this.getStorageProvider(null);
    }

    public StorageProvider getStorageProvider(String storageAccountId) throws StorageException {
        if (this.storageProviders.containsKey(storageAccountId = this.checkStorageAccountId(storageAccountId))) {
            return this.storageProviders.get(storageAccountId);
        }
        StorageAccountManager storageAccountManager = this.getAccountManager();
        StorageAccount account = storageAccountManager.getStorageAccount(storageAccountId);
        if (account == null) {
            throw new NotFoundException("No store exists with ID " + storageAccountId);
        }
        String username = account.getUsername();
        String password = account.getPassword();
        StorageProviderType type = account.getType();
        Object storageProvider = null;
        if (type.equals((Object)StorageProviderType.AMAZON_S3)) {
            storageProvider = new S3StorageProvider(username, password, account.getOptions());
        } else if (type.equals((Object)StorageProviderType.SWIFT_S3)) {
            storageProvider = new SwiftStorageProvider(username, password, account.getOptions());
        } else if (type.equals((Object)StorageProviderType.AMAZON_GLACIER)) {
            storageProvider = new GlacierStorageProvider(username, password, account.getOptions());
        } else if (type.equals((Object)StorageProviderType.IRODS)) {
            storageProvider = new IrodsStorageProvider(username, password, account.getOptions());
        } else if (type.equals((Object)StorageProviderType.CHRONOPOLIS)) {
            storageProvider = new ChronopolisStorageProvider(username, password, account.getOptions());
        } else if (type.equals((Object)StorageProviderType.TEST_RETRY)) {
            storageProvider = new MockRetryStorageProvider();
        } else if (type.equals((Object)StorageProviderType.TEST_VERIFY_CREATE)) {
            storageProvider = new MockVerifyCreateStorageProvider();
        } else if (type.equals((Object)StorageProviderType.TEST_VERIFY_DELETE)) {
            storageProvider = new MockVerifyDeleteStorageProvider();
        } else {
            throw new StorageException("Unsupported storage provider type (" + type.name() + ")  associated with storage account (" + storageAccountId + "): unable to create");
        }
        AuditStorageProvider auditProvider = new AuditStorageProvider((StorageProvider)storageProvider, storageAccountManager.getAccountName(), storageAccountId, type.getName(), this.userUtil, this.auditQueue);
        if (storageProvider instanceof StorageProviderBase) {
            ((StorageProviderBase)storageProvider).setWrappedStorageProvider((StorageProvider)auditProvider);
        }
        ACLStorageProvider aclProvider = new ACLStorageProvider((StorageProvider)auditProvider, this.notifier, this.contextUtil);
        BrokeredStorageProvider brokeredProvider = new BrokeredStorageProvider(this.statelessProvider, (StorageProvider)aclProvider, type, storageAccountId);
        this.storageProviders.put(storageAccountId, (StorageProvider)brokeredProvider);
        return brokeredProvider;
    }

    private String checkStorageAccountId(String storageAccountId) {
        if (null == storageAccountId) {
            return this.getAccountManager().getPrimaryStorageAccount().getId();
        }
        return storageAccountId;
    }

    public void expireStorageProvider(String storageAccountId) {
        storageAccountId = this.checkStorageAccountId(storageAccountId);
        this.log.info("Expiring storage provider connection!  Storage account id: {}", (Object)storageAccountId);
        this.storageProviders.remove(storageAccountId);
    }
}

