/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.aop;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.util.Map;
import org.duracloud.error.UnauthorizedException;
import org.duracloud.security.util.AuthorizationHelper;
import org.duracloud.snapshot.id.SnapshotIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.core.Ordered;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SnapshotAccessAdvice
implements MethodBeforeAdvice,
Ordered {
    private Logger log = LoggerFactory.getLogger(SnapshotAccessAdvice.class);
    private int order = 0;
    private AuthorizationHelper authHelper;

    public SnapshotAccessAdvice(AuthorizationHelper authHelper) {
        this.authHelper = authHelper;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void before(Method method, Object[] args, Object target) throws Throwable {
        String taskName = (String)args[0];
        if (!taskName.matches("get-snapshot[^s]?(-.+)?")) {
            return;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (this.authHelper.hasAdmin(auth)) {
            return;
        }
        String taskParams = (String)args[1];
        ObjectMapper mapper = new ObjectMapper();
        JsonParser parser = mapper.getJsonFactory().createJsonParser(taskParams);
        JsonNode node = (JsonNode)parser.readValueAsTree();
        String rawSnapshotId = node.get("snapshotId").asText();
        SnapshotIdentifier snapshotId = SnapshotIdentifier.parseSnapshotId((String)rawSnapshotId);
        String sourceSpaceId = snapshotId.getSpaceId();
        String sourceStoreId = snapshotId.getStoreId();
        Map acls = this.authHelper.getSpaceACLs(sourceStoreId, sourceSpaceId);
        if (!this.authHelper.hasReadAccess(auth.getName(), acls) && !this.authHelper.groupsHaveReadAccess(auth, acls)) {
            this.log.error(auth.getName() + " is not authorized to view " + rawSnapshotId);
            throw new UnauthorizedException("You are not authorized to access snapshot " + rawSnapshotId + ".");
        }
        this.log.debug("successfully authorized {} to view {}", (Object)auth.getName(), (Object)rawSnapshotId);
    }
}

