/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.io.InputStream;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.duracloud.common.rest.RestUtil;
import org.duracloud.common.util.IOUtil;
import org.duracloud.common.util.SerializationUtil;
import org.duracloud.durastore.rest.BaseRest;
import org.duracloud.error.UnauthorizedException;
import org.duracloud.storage.error.ServerConflictException;
import org.duracloud.storage.error.StorageStateException;
import org.duracloud.storage.error.UnsupportedTaskException;
import org.duracloud.storage.provider.TaskProvider;
import org.duracloud.storage.provider.TaskProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Path(value="/task")
@Component
public class TaskRest
extends BaseRest {
    private final Logger log = LoggerFactory.getLogger(TaskRest.class);
    private TaskProviderFactory taskProviderFactory;
    private RestUtil restUtil;

    @Autowired
    public TaskRest(@Qualifier(value="taskProviderFactory") TaskProviderFactory taskProviderFactory, RestUtil restUtil) {
        this.taskProviderFactory = taskProviderFactory;
        this.restUtil = restUtil;
    }

    @GET
    public Response getSupportedTasks(@QueryParam(value="storeID") String storeID) {
        String msg = "getting suppported tasks(" + storeID + ")";
        try {
            TaskProvider taskProvider = this.taskProviderFactory.getTaskProvider(storeID);
            List supportedTasks = taskProvider.getSupportedTasks();
            String responseText = SerializationUtil.serializeList((List)supportedTasks);
            return this.responseOkXml(msg, responseText);
        }
        catch (Exception e) {
            return this.responseBad(msg, e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Path(value="/{taskName}")
    @POST
    public Response performTask(@PathParam(value="taskName") String taskName, @QueryParam(value="storeID") String storeID) {
        String msg = "performing task(" + taskName + ", " + storeID + ")";
        String taskParameters = null;
        try {
            taskParameters = this.getTaskParameters();
        }
        catch (Exception e) {
            return this.responseBad(msg, e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        try {
            TaskProvider taskProvider = this.taskProviderFactory.getTaskProvider(storeID);
            String responseText = taskProvider.performTask(taskName, taskParameters);
            return this.responseOk(msg, responseText);
        }
        catch (UnsupportedTaskException e) {
            return this.responseBad(msg, (Exception)((Object)e), Response.Status.BAD_REQUEST);
        }
        catch (UnauthorizedException e) {
            return this.responseBad(msg, (Exception)((Object)e), Response.Status.FORBIDDEN);
        }
        catch (StorageStateException e) {
            return this.responseBad(msg, (Exception)((Object)e), Response.Status.CONFLICT);
        }
        catch (ServerConflictException e) {
            return this.responseBad(msg, (Exception)((Object)e), Response.Status.CONFLICT);
        }
        catch (Exception e) {
            return this.responseBad(msg, e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getTaskParameters() throws Exception {
        InputStream contentStream;
        String taskParams = null;
        RestUtil.RequestContent content = this.restUtil.getRequestContent(this.request, this.headers);
        if (content != null && (contentStream = content.getContentStream()) != null) {
            taskParams = IOUtil.readStringFromStream((InputStream)contentStream);
        }
        return taskParams;
    }

    private Response responseOk(String msg, String text) {
        this.log.debug(msg);
        return Response.ok((Object)text, (MediaType)TEXT_PLAIN).build();
    }

    private Response responseOkXml(String msg, String text) {
        this.log.debug(msg);
        return Response.ok((Object)text, (MediaType)APPLICATION_XML).build();
    }

    private Response responseBad(String msg, Exception e, Response.Status status) {
        this.log.error("Error: " + msg, (Throwable)e);
        String entity = e.getMessage() == null ? "null" : e.getMessage();
        return Response.status((Response.Status)status).entity((Object)entity).build();
    }
}

