/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.http.client.utils.URIBuilder;
import org.duracloud.common.constant.ManifestFormat;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.common.util.DateUtil;
import org.duracloud.common.util.IOUtil;
import org.duracloud.durastore.rest.BaseRest;
import org.duracloud.durastore.rest.ManifestResource;
import org.duracloud.manifest.error.ManifestArgumentException;
import org.duracloud.manifest.error.ManifestNotFoundException;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.util.StorageProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/manifest")
@Component
public class ManifestRest
extends BaseRest {
    private final Logger log = LoggerFactory.getLogger(ManifestRest.class);
    private ManifestResource manifestResource;
    private boolean enabled = true;
    private StorageProviderFactory storageProviderFactory;
    private static Executor executor = Executors.newFixedThreadPool(10);
    private static final String DEFAULT_FORMAT = ManifestFormat.TSV.name();

    @Autowired
    public ManifestRest(ManifestResource manifestResource, StorageProviderFactory storageProviderFactory) {
        this.manifestResource = manifestResource;
        this.storageProviderFactory = storageProviderFactory;
    }

    @Path(value="/{spaceId}")
    @GET
    public Response getManifest(@PathParam(value="spaceId") String spaceId, @QueryParam(value="format") String format, @QueryParam(value="storeID") String storeId) {
        if (!this.enabled) {
            return Response.status((int)501).entity((Object)"This endpoint is currently disabled.").build();
        }
        if (format == null) {
            format = DEFAULT_FORMAT;
        }
        String account = this.getSubdomain();
        this.log.info("getting manifest, {}:{}:{} [{}]", new Object[]{account, storeId, spaceId, format});
        try {
            InputStream manifest = this.manifestResource.getManifest(account, storeId, spaceId, format);
            return Response.ok((Object)manifest).type(ManifestFormat.valueOf((String)format).getMimeType()).build();
        }
        catch (ManifestArgumentException e) {
            this.log.error("Error for, {}:{} [{}]", new Object[]{storeId, spaceId, format, e});
            return this.responseBadRequest((Exception)((Object)e));
        }
        catch (ManifestNotFoundException e) {
            this.log.error("Error for, {}:{} [{}]", new Object[]{storeId, spaceId, format, e});
            return this.responseNotFound(e.getMessage());
        }
        catch (Exception e) {
            this.log.error("Error for, {}:{} [{}]", new Object[]{storeId, spaceId, format, e});
            return this.responseBad(e);
        }
    }

    @Path(value="/{spaceId}")
    @POST
    public Response generateManifest(@PathParam(value="spaceId") String spaceId, @QueryParam(value="format") String format, @QueryParam(value="storeID") String storeId) {
        if (!this.enabled) {
            return Response.status((int)501).entity((Object)"This endpoint is currently disabled.").build();
        }
        if (format == null) {
            format = DEFAULT_FORMAT;
        }
        String account = this.getSubdomain();
        this.log.info("generating manifest, {}:{}:{} [{}]", new Object[]{account, storeId, spaceId, format});
        try {
            URI uri = this.generateAsynchronously(account, spaceId, storeId, format);
            return Response.accepted((Object)("We are processing your manifest generation request. To retrieve your file, please poll the URI in the Location header of this response: (" + uri + ").")).location(uri).build();
        }
        catch (ManifestArgumentException e) {
            this.log.error("Error for, {}:{} [{}]", new Object[]{storeId, spaceId, format, e});
            return this.responseBadRequest((Exception)((Object)e));
        }
        catch (ManifestNotFoundException e) {
            this.log.error("Error for, {}:{} [{}]", new Object[]{storeId, spaceId, format, e});
            return this.responseNotFound(e.getMessage());
        }
        catch (Exception e) {
            this.log.error("Error for, {}:{} [{}]", new Object[]{storeId, spaceId, format, e});
            return this.responseBad(e);
        }
    }

    private URI generateAsynchronously(String account, String spaceId, String storeId, String format) throws Exception {
        StorageProviderType providerType = this.getStorageProviderType(storeId);
        InputStream manifest = this.manifestResource.getManifest(account, storeId, spaceId, format);
        String contentId = MessageFormat.format("generated-manifests/manifest-{0}_{1}_{2}.txt{3}", spaceId, providerType.name().toLowerCase(), DateUtil.convertToString((long)System.currentTimeMillis(), (DateUtil.DateFormat)DateUtil.DateFormat.PLAIN_FORMAT), ".gz");
        String adminSpace = "x-duracloud-admin";
        URI uri = this.buildURI(adminSpace, contentId);
        StorageProvider provider = this.storageProviderFactory.getStorageProvider();
        executor.execute(() -> {
            try {
                boolean gzip = true;
                File file = IOUtil.writeStreamToFile((InputStream)manifest, (boolean)gzip);
                this.uploadManifestToDefaultStorageProvider(format, adminSpace, contentId, file, provider, gzip);
            }
            catch (Exception ex) {
                this.log.error("failed to generate manifest for space: spaceId=" + spaceId + ", storeId=" + storeId + " : " + ex.getMessage(), (Throwable)ex);
            }
        });
        return uri;
    }

    private StorageProviderType getStorageProviderType(String storeId) {
        for (StorageAccount a : this.storageProviderFactory.getStorageAccounts()) {
            if (!(storeId == null ? a.isPrimary() : storeId.equals(a.getId()))) continue;
            return a.getType();
        }
        throw new DuraCloudRuntimeException("storage provider type could not be resolved");
    }

    protected URI buildURI(String adminSpace, String contentId) throws URISyntaxException {
        String host = this.request.getAttribute("org.duracloud.request.host").toString();
        int port = (Integer)this.request.getAttribute("org.duracloud.request.port");
        String context = this.request.getContextPath();
        URIBuilder builder = new URIBuilder().setHost(host).setScheme("http" + (port == 443 ? "s" : "")).setPath(context + "/" + adminSpace + "/" + contentId);
        if (port != 443 && port != 80) {
            builder = builder.setPort(port);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadManifestToDefaultStorageProvider(final String format, final String adminSpace, final String contentId, final File file, final StorageProvider provider, final boolean gzipped) throws Exception {
        try {
            ChecksumUtil util = new ChecksumUtil(ChecksumUtil.Algorithm.MD5);
            final String checksum = util.generateChecksum(file);
            new Retrier().execute(new Retriable(){

                public Object retry() throws Exception {
                    String string;
                    FileInputStream content = new FileInputStream(file);
                    try {
                        HashMap<String, String> props = new HashMap<String, String>();
                        if (gzipped) {
                            props.put("Content-Encoding", "gzip");
                        }
                        string = provider.addContent(adminSpace, contentId, ManifestFormat.valueOf((String)format.toUpperCase()).getMimeType(), props, file.length(), checksum, (InputStream)content);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                content.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception ex) {
                            throw new DuraCloudRuntimeException((Throwable)ex);
                        }
                    }
                    content.close();
                    return string;
                }
            });
        }
        finally {
            file.delete();
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

