/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Map;
import org.duracloud.durastore.error.ResourceChecksumException;
import org.duracloud.durastore.error.ResourceException;
import org.duracloud.durastore.error.ResourceNotFoundException;
import org.duracloud.durastore.error.ResourcePropertiesInvalidException;
import org.duracloud.durastore.error.ResourceStateException;
import org.duracloud.durastore.rest.ContentResource;
import org.duracloud.storage.domain.RetrievedContent;
import org.duracloud.storage.error.ChecksumMismatchException;
import org.duracloud.storage.error.InvalidIdException;
import org.duracloud.storage.error.InvalidRequestException;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.error.StorageStateException;
import org.duracloud.storage.provider.BrokeredStorageProvider;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.util.IdUtil;
import org.duracloud.storage.util.StorageProviderFactory;
import org.duracloud.storage.util.StorageProviderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentResourceImpl
implements ContentResource {
    private static final Logger log = LoggerFactory.getLogger(ContentResource.class);
    private StorageProviderFactory storageProviderFactory;

    public ContentResourceImpl(StorageProviderFactory storageProviderFactory) {
        this.storageProviderFactory = storageProviderFactory;
    }

    public RetrievedContent getContent(String spaceID, String contentID, String storeID, String range) throws InvalidRequestException, ResourceException {
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            return storage.getContent(spaceID, contentID, range);
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("get content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (StorageStateException e) {
            throw new ResourceStateException("get content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRequestException(e.getMessage());
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("get content", spaceID, contentID, (Throwable)e);
        }
    }

    public Map<String, String> getContentProperties(String spaceID, String contentID, String storeID) throws ResourceException {
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            return storage.getContentProperties(spaceID, contentID);
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("get properties for content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("get properties for content", spaceID, contentID, (Throwable)e);
        }
    }

    public void updateContentProperties(String spaceID, String contentID, String contentMimeType, Map<String, String> userProperties, String storeID) throws ResourceException {
        this.validateProperties(userProperties, "update properties for content", spaceID, contentID);
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            if (userProperties != null) {
                storage.setContentProperties(spaceID, contentID, userProperties);
            }
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("update properties for content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (StorageStateException e) {
            throw new ResourceStateException("update properties for content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("update properties for content", spaceID, contentID, (Throwable)e);
        }
    }

    private void validateProperties(Map<String, String> userProperties, String task, String spaceId, String contentId) throws ResourcePropertiesInvalidException {
        StringBuilder message = new StringBuilder();
        for (Map.Entry<String, String> entry : userProperties.entrySet()) {
            if (!this.isAllUSASCII(entry.getKey())) {
                message.append("The property name '" + entry.getKey() + "' is invalid. Only US-ASCII characters are allowed.  ");
            }
            if (this.isAllUSASCII(entry.getValue())) continue;
            message.append("The property value '" + entry.getValue() + "' is invalid. Only US-ASCII characters are allowed.  ");
        }
        if (message.length() > 0) {
            throw new ResourcePropertiesInvalidException(task, spaceId, contentId, new Exception(message.toString()));
        }
    }

    private boolean isAllUSASCII(String value) {
        if (value != null) {
            CharsetEncoder encoder = Charset.forName("US-ASCII").newEncoder();
            return encoder.canEncode(value);
        }
        return true;
    }

    public String addContent(String spaceID, String contentID, InputStream content, String contentMimeType, Map<String, String> userProperties, long contentSize, String checksum, String storeID) throws ResourceException, InvalidIdException, ResourcePropertiesInvalidException {
        IdUtil.validateContentId((String)contentID);
        this.validateProperties(userProperties, "add content", spaceID, contentID);
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            try {
                Map oldUserProperties = storage.getContentProperties(spaceID, contentID);
                if (userProperties != null) {
                    oldUserProperties.putAll(userProperties);
                    String oldMimetype = (String)oldUserProperties.remove("content-mimetype");
                    if (contentMimeType == null || contentMimeType.trim() == "") {
                        contentMimeType = oldMimetype;
                    }
                    oldUserProperties = StorageProviderUtil.removeCalculatedProperties((Map)oldUserProperties);
                }
                userProperties = oldUserProperties;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            return storage.addContent(spaceID, contentID, contentMimeType, userProperties, contentSize, checksum, content);
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("add content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (ChecksumMismatchException e) {
            throw new ResourceChecksumException("add content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("add content", spaceID, contentID, (Throwable)e);
        }
    }

    public String copyContent(String srcStoreID, String srcSpaceID, String srcContentID, String destStoreID, String destSpaceID, String destContentID) throws ResourceException {
        BrokeredStorageProvider destProvider;
        BrokeredStorageProvider srcProvider = this.getStorageProvider(srcStoreID);
        if (srcProvider.equals(destProvider = this.getStorageProvider(destStoreID))) {
            return this.copyContent((StorageProvider)srcProvider, srcSpaceID, srcContentID, destSpaceID, destContentID, srcStoreID);
        }
        return this.copyContentBetweenStorageProviders(srcProvider, srcSpaceID, srcContentID, srcStoreID, destProvider, destSpaceID, destContentID, destStoreID);
    }

    private BrokeredStorageProvider getStorageProvider(String storeID) {
        return (BrokeredStorageProvider)this.storageProviderFactory.getStorageProvider(storeID);
    }

    private String copyContentBetweenStorageProviders(BrokeredStorageProvider srcStorage, String srcSpaceID, String srcContentID, String srcStoreID, BrokeredStorageProvider destStorage, String destSpaceID, String destContentID, String destStoreID) throws ResourceException {
        String string;
        block13: {
            RetrievedContent retrievedContent = srcStorage.getContent(srcSpaceID, srcContentID);
            InputStream inputStream = retrievedContent.getContentStream();
            try {
                String md5;
                Map properties = retrievedContent.getContentProperties();
                Long contentSize = null;
                try {
                    String contentSizeString = (String)properties.get("content-size");
                    if (contentSizeString != null) {
                        contentSize = Long.parseLong(contentSizeString);
                    }
                }
                catch (NumberFormatException ex) {
                    String msg = "content size could not be parsed: " + ex.getMessage();
                    log.warn(msg, (Throwable)ex);
                }
                string = md5 = destStorage.addContent(destSpaceID, destContentID, (String)properties.get("content-mimetype"), properties, contentSize.longValue(), (String)properties.get("content-checksum"), inputStream);
                if (inputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NotFoundException e) {
                    throw new ResourceNotFoundException("copy content", srcStorage.getTargetType().name(), srcSpaceID, srcContentID, destStorage.getTargetType().name(), destSpaceID, destContentID, (Throwable)e);
                }
                catch (StorageStateException e) {
                    throw new ResourceStateException("copy content", srcStorage.getTargetType().name(), srcSpaceID, srcContentID, destStorage.getTargetType().name(), destSpaceID, destContentID, (Throwable)e);
                }
                catch (Exception e) {
                    this.storageProviderFactory.expireStorageProvider(srcStoreID);
                    this.storageProviderFactory.expireStorageProvider(destStoreID);
                    throw new ResourceException("copy content", srcStorage.getTargetType().name(), srcSpaceID, srcContentID, destStorage.getTargetType().name(), destSpaceID, destContentID, (Throwable)e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    private String copyContent(StorageProvider storage, String srcSpaceID, String srcContentID, String destSpaceID, String destContentID, String storeID) throws ResourceException {
        try {
            return storage.copyContent(srcSpaceID, srcContentID, destSpaceID, destContentID);
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("copy content", srcSpaceID, srcContentID, destSpaceID, destContentID, (Throwable)e);
        }
        catch (StorageStateException e) {
            throw new ResourceStateException("copy content", srcSpaceID, srcContentID, destSpaceID, destContentID, (Throwable)e);
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("copy content", srcSpaceID, srcContentID, destSpaceID, destContentID, (Throwable)e);
        }
    }

    public void deleteContent(String spaceID, String contentID, String storeID) throws ResourceException {
        try {
            StorageProvider storage = this.storageProviderFactory.getStorageProvider(storeID);
            storage.deleteContent(spaceID, contentID);
        }
        catch (NotFoundException e) {
            throw new ResourceNotFoundException("delete content", spaceID, contentID, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storageProviderFactory.expireStorageProvider(storeID);
            throw new ResourceException("delete content", spaceID, contentID, (Throwable)e);
        }
    }
}

