/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.durastore.rest.BaseRest;
import org.duracloud.durastore.rest.StorageStatsResource;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.util.StorageProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/report")
@Component
public class StorageStatsRest
extends BaseRest {
    private final Logger log = LoggerFactory.getLogger(StorageStatsRest.class);
    private StorageStatsResource resource;
    private StorageProviderFactory storageProviderFactory;

    @Autowired
    public StorageStatsRest(StorageStatsResource resource, StorageProviderFactory storageProviderFactory) {
        this.resource = resource;
        this.storageProviderFactory = storageProviderFactory;
    }

    @Path(value="/space/{spaceID}")
    @GET
    @Produces(value={"application/json"})
    public Response getSpaceStatsOverTime(@PathParam(value="spaceID") String spaceId, @QueryParam(value="storeID") String storeId, @QueryParam(value="start") String startMs, @QueryParam(value="end") String endMs, @QueryParam(value="groupBy") String groupBy) {
        String account = this.getSubdomain();
        this.log.info("getting storage stats, {}:{}:{} [{}:{}]", new Object[]{account, storeId, spaceId, startMs, endMs});
        try {
            Date startDate = this.resolveStartDate(startMs);
            Date endDate = this.resolveEndDate(endMs);
            storeId = this.getStoreId(storeId);
            this.ensureSpaceIsValid(storeId, spaceId);
            List stats = this.resource.getSpaceStats(account, storeId, spaceId, startDate, endDate, this.getGroupBy(groupBy));
            return this.responseOk((Object)stats);
        }
        catch (Exception e) {
            return this.handleException(e, MessageFormat.format("error getting storage stats, {0}:{1}:{2} [{3}:{4}]", account, storeId, spaceId, startMs, endMs));
        }
    }

    private void ensureSpaceIsValid(String storeId, String spaceId) throws org.duracloud.error.NotFoundException {
        StorageProvider provider = this.storageProviderFactory.getStorageProvider(storeId);
        try {
            provider.getSpaceProperties(spaceId);
        }
        catch (NotFoundException ex) {
            throw new org.duracloud.error.NotFoundException("The space was not found: " + spaceId);
        }
    }

    @Path(value="/store")
    @GET
    @Produces(value={"application/json"})
    public Response getStoreStatsOverTime(@QueryParam(value="storeID") String storeId, @QueryParam(value="start") String startMs, @QueryParam(value="end") String endMs, @QueryParam(value="groupBy") String groupBy) {
        String account = this.getSubdomain();
        this.log.info("getting storage stats, {}:{} [{}:{}]", new Object[]{account, storeId, startMs, endMs});
        try {
            Date startDate = this.resolveStartDate(startMs);
            Date endDate = this.resolveEndDate(endMs);
            storeId = this.getStoreId(storeId);
            List stats = this.resource.getStorageProviderStats(account, storeId, startDate, endDate, this.getGroupBy(groupBy));
            return this.responseOk((Object)stats);
        }
        catch (Exception e) {
            return this.handleException(e, MessageFormat.format("error getting storage stats, {0}:{1} [{3}:{4}]", account, storeId, startMs, endMs));
        }
    }

    private StorageStatsResource.GroupBy getGroupBy(String groupBy) {
        if (groupBy == null) {
            return StorageStatsResource.GroupBy.day;
        }
        try {
            return StorageStatsResource.GroupBy.valueOf((String)groupBy.toLowerCase());
        }
        catch (IllegalArgumentException ex) {
            String message = groupBy + " is not a valid value for the groupBy parameter. You must specify one of the following values: " + StringUtils.join((Object[])StorageStatsResource.GroupBy.values(), (String)",");
            throw new IllegalArgumentException(message, ex);
        }
    }

    protected Date resolveEndDate(String endMs) {
        Date endDate = new Date();
        if (null != endMs) {
            endDate = this.toDateFromMs(endMs);
        }
        return endDate;
    }

    protected Date resolveStartDate(String startMs) {
        Date startDate = null == startMs ? new Date(0L) : this.toDateFromMs(startMs);
        return startDate;
    }

    protected Date toDateFromMs(String endMs) throws NumberFormatException {
        try {
            return new Date(Long.parseLong(endMs));
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("Unable to parse date: " + endMs + ". Input value must be in epoch milliseconds.");
        }
    }

    @Path(value="/store/{date}")
    @GET
    @Produces(value={"application/json"})
    public Response getStorageStatsByDay(@QueryParam(value="storeID") String storeId, @PathParam(value="date") String dateMs) {
        String account = this.getSubdomain();
        this.log.info("getting storage stats, {}:{}:{} [{}]", new Object[]{account, storeId, dateMs});
        try {
            Date theDate = this.toDateFromMs(dateMs);
            storeId = this.getStoreId(storeId);
            List stats = this.resource.getStorageProviderByDay(account, storeId, theDate);
            return this.responseOk((Object)stats);
        }
        catch (Exception e) {
            return this.handleException(e, MessageFormat.format("error getting storage stats, {0}:{1}:{2} [{3}]", account, storeId, dateMs));
        }
    }

    private Response handleException(Exception e, String defaultErrorMessage) {
        if (e instanceof NumberFormatException || e instanceof IllegalArgumentException) {
            this.log.error(e.getMessage(), (Throwable)e);
            return this.responseBad(e, Response.Status.BAD_REQUEST);
        }
        if (e instanceof org.duracloud.error.NotFoundException) {
            this.log.error(e.getMessage(), (Throwable)e);
            return this.responseBad(e, Response.Status.NOT_FOUND);
        }
        this.log.error(defaultErrorMessage, (Throwable)e);
        return this.responseBad(e);
    }

    protected String getStoreId(String storeId) throws org.duracloud.error.NotFoundException {
        if (storeId == null) {
            List accounts = this.storageProviderFactory.getStorageAccounts();
            for (StorageAccount sa : accounts) {
                if (!sa.isPrimary()) continue;
                storeId = sa.getId();
                break;
            }
            if (storeId == null) {
                throw new DuraCloudRuntimeException("unable to resolve primary store id");
            }
        } else {
            List accounts = this.storageProviderFactory.getStorageAccounts();
            boolean valid = false;
            for (StorageAccount sa : accounts) {
                if (!storeId.equals(sa.getId())) continue;
                valid = true;
                break;
            }
            if (!valid) {
                throw new org.duracloud.error.NotFoundException("Store id (" + storeId + ") is not associated with this account.");
            }
        }
        return storeId;
    }
}

