/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.rest;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.duracloud.durastore.rest.BaseRest;
import org.duracloud.s3storage.StringDataStore;
import org.duracloud.s3storage.StringDataStoreFactory;
import org.duracloud.s3storageprovider.dto.SignedCookieData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/aux")
@Component
public class AuxRest
extends BaseRest {
    private final Logger log = LoggerFactory.getLogger(AuxRest.class);
    @Inject
    private StringDataStoreFactory stringDataStoreFactory;

    @VisibleForTesting
    protected void setStringDataStoreFactory(StringDataStoreFactory stringDataStoreFactory) {
        this.stringDataStoreFactory = stringDataStoreFactory;
    }

    @Path(value="/cookies")
    @GET
    public Response getCookies(@QueryParam(value="token") String token) {
        try {
            StringDataStore dataStore = this.stringDataStoreFactory.create("signedcookies");
            String cookiesData = dataStore.retrieveData(token);
            if (null == cookiesData) {
                return this.responseNotFound("Token not found");
            }
            SignedCookieData cookieData = SignedCookieData.deserialize((String)cookiesData);
            String streamingHost = cookieData.getStreamingHost();
            Map cookies = cookieData.getSignedCookies();
            ArrayList<NewCookie> responseCookies = new ArrayList<NewCookie>();
            for (String cookieKey : cookies.keySet()) {
                responseCookies.add(new NewCookie(cookieKey, (String)cookies.get(cookieKey), "/;SameSite=None", streamingHost, "Supports HLS", -1, true));
            }
            String redirectUrl = cookieData.getRedirectUrl();
            String html = "<html><head><meta http-equiv='refresh' content='0;URL=\"" + redirectUrl + "\"' /></head></html>";
            String origin = "*";
            String requestingOrigin = this.request.getHeader("Origin");
            if (!StringUtils.isEmpty((CharSequence)requestingOrigin)) {
                origin = requestingOrigin;
            }
            return Response.ok((Object)html, (MediaType)MediaType.TEXT_HTML_TYPE).header("Access-Control-Allow-Origin", (Object)origin).header("Access-Control-Allow-Credentials", (Object)"true").header("Vary", (Object)"Origin").cookie(responseCookies.toArray(new NewCookie[responseCookies.size()])).build();
        }
        catch (Exception e) {
            return this.responseBad(e);
        }
    }
}

