/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.durastore.util;

import org.duracloud.account.db.model.DuracloudMill;
import org.duracloud.account.db.model.RabbitmqConfig;
import org.duracloud.account.db.repo.DuracloudMillRepo;
import org.duracloud.common.queue.QueueType;
import org.duracloud.storage.domain.AuditConfig;

public class AuditConfigBuilder {
    private DuracloudMillRepo millRepo;

    public AuditConfigBuilder(DuracloudMillRepo millRepo) {
        this.millRepo = millRepo;
    }

    public AuditConfig build() {
        AuditConfig config = new AuditConfig();
        DuracloudMill mill = (DuracloudMill)this.millRepo.findAll().get(0);
        config.setAuditLogSpaceId(mill.getAuditLogSpaceId());
        config.setAuditQueueName(mill.getAuditQueue());
        config.setQueueType(QueueType.fromString((String)mill.getQueueType()));
        RabbitmqConfig rmqConf = mill.getRabbitmqConfig();
        if (null != rmqConf) {
            config.setRabbitmqHost(rmqConf.getHost());
            config.setRabbitmqPort(rmqConf.getPort());
            config.setRabbitmqVhost(rmqConf.getVhost());
            config.setRabbitmqExchange(mill.getRabbitmqExchange());
            config.setRabbitmqUsername(rmqConf.getUsername());
            config.setRabbitmqPassword(rmqConf.getPassword());
        }
        return config;
    }
}

