/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.glacierstorage;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.StorageClass;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.error.StorageStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlacierStorageProvider
extends S3StorageProvider {
    protected static final String INVALID_OBJECT_STATE = "InvalidObjectState";
    private final Logger log = LoggerFactory.getLogger(GlacierStorageProvider.class);

    public GlacierStorageProvider(String accessKey, String secretKey) {
        super(accessKey, secretKey);
    }

    public GlacierStorageProvider(AmazonS3Client s3Client, String accessKey) {
        super(s3Client, accessKey, null);
    }

    public void createSpace(String spaceId) {
        this.log.debug("createSpace(" + spaceId + ")");
        super.createSpace(spaceId);
        BucketLifecycleConfiguration.Transition transition = new BucketLifecycleConfiguration.Transition().withDays(0).withStorageClass(StorageClass.Glacier);
        BucketLifecycleConfiguration.Rule rule = new BucketLifecycleConfiguration.Rule().withId("Archive all files").withPrefix("").withTransition(transition).withStatus("Enabled".toString());
        ArrayList<BucketLifecycleConfiguration.Rule> rules = new ArrayList<BucketLifecycleConfiguration.Rule>();
        rules.add(rule);
        BucketLifecycleConfiguration config = new BucketLifecycleConfiguration().withRules(rules);
        this.setNewSpaceLifecycle(spaceId, config);
    }

    protected void setNewSpaceLifecycle(String spaceId, BucketLifecycleConfiguration config) {
        boolean success = false;
        int maxLoops = 6;
        for (int loops = 0; !success && loops < maxLoops; ++loops) {
            try {
                this.s3Client.setBucketLifecycleConfiguration(this.getBucketName(spaceId), config);
                success = true;
                continue;
            }
            catch (NotFoundException e) {
                success = false;
                this.wait(loops);
            }
        }
        if (!success) {
            throw new StorageException("Lifecycle policy (to use Glacier) for space " + spaceId + " could not be applied. The space cannot be found.");
        }
    }

    public String copyContent(String sourceSpaceId, String sourceContentId, String destSpaceId, String destContentId) {
        try {
            return super.copyContent(sourceSpaceId, sourceContentId, destSpaceId, destContentId);
        }
        catch (StorageException e) {
            this.checkStorageState(e);
            throw e;
        }
    }

    public InputStream getContent(String spaceId, String contentId) {
        this.log.debug("getContent(" + spaceId + ", " + contentId + ")");
        try {
            return super.getContent(spaceId, contentId);
        }
        catch (StorageException e) {
            this.checkStorageState(e);
            throw e;
        }
    }

    public void setContentProperties(String spaceId, String contentId, Map<String, String> contentProperties) {
        this.log.debug("setContentProperties(" + spaceId + ", " + contentId + ")");
        try {
            super.setContentProperties(spaceId, contentId, contentProperties);
        }
        catch (StorageException e) {
            this.checkStorageState(e);
            throw e;
        }
    }

    private void checkStorageState(StorageException e) {
        String errorCode;
        if (e.getCause() instanceof AmazonS3Exception && INVALID_OBJECT_STATE.equals(errorCode = ((AmazonS3Exception)e.getCause()).getErrorCode())) {
            String message = "The storage state of this content item does not allow for this action to be taken. To resolve this issue: 1. Request that this content item be retrieved from offline storage 2. Wait (retrieval may take up to 5 hours) 3. Retry this request";
            throw new StorageStateException(message, (Throwable)e);
        }
    }
}

