/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.irodsstorage;

import edu.umiacs.irods.api.IRodsConnection;
import edu.umiacs.irods.api.IRodsRequestException;
import edu.umiacs.irods.api.pi.ErrorEnum;
import edu.umiacs.irods.api.pi.GenQueryEnum;
import edu.umiacs.irods.api.pi.ObjTypeEnum;
import edu.umiacs.irods.api.pi.RodsObjStat_PI;
import edu.umiacs.irods.operation.ConnectOperation;
import edu.umiacs.irods.operation.IrodsOperations;
import edu.umiacs.irods.operation.IrodsOutputStream;
import edu.umiacs.irods.operation.IrodsProxyInputStream;
import edu.umiacs.irods.operation.MetaDataMap;
import edu.umiacs.irods.operation.QueryBuilder;
import edu.umiacs.irods.operation.QueryResult;
import edu.umiacs.irods.operation.UnknownSizeOutputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.duracloud.common.model.AclType;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrodsStorageProvider
implements StorageProvider {
    private final Logger log = LoggerFactory.getLogger(IrodsStorageProvider.class);
    private String baseDirectory;
    private String username;
    private String password;
    private int port;
    private String zone;
    private String host;
    private String storageResource;
    private static final int BLOCK_SIZE = 32768;

    public IrodsStorageProvider(String username, String password, Map<String, String> options) {
        if (options == null) {
            throw new StorageException("Missing required options");
        }
        this.password = password;
        this.username = username;
        this.zone = this.getOptionString(StorageAccount.OPTS.ZONE.name(), options);
        this.port = this.getOptionInt(StorageAccount.OPTS.PORT.name(), options);
        this.host = this.getOptionString(StorageAccount.OPTS.HOST.name(), options);
        this.baseDirectory = this.getOptionString(StorageAccount.OPTS.BASE_DIRECTORY.name(), options);
        this.storageResource = this.getOptionString(StorageAccount.OPTS.RESOURCE.name(), options);
        this.log.trace("Creating new irods provider " + username + "#" + this.zone + "@" + this.host + ":" + this.port + this.baseDirectory + " rsrc " + this.storageResource);
    }

    public StorageProviderType getStorageProviderType() {
        return StorageProviderType.IRODS;
    }

    public Iterator<String> getSpaces() {
        ConnectOperation co = new ConnectOperation(this.host, this.port, this.username, this.password, this.zone);
        this.log.trace("Listing spaces");
        try {
            return this.listDirectories(this.baseDirectory, co.getConnection());
        }
        catch (IOException e) {
            this.log.error("Could not connect to iRODS", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public Iterator<String> getSpaceContents(String spaceId, String prefix) {
        ConnectOperation co = new ConnectOperation(this.host, this.port, this.username, this.password, this.zone);
        String path = prefix != null && !prefix.equals("") ? this.baseDirectory + "/" + spaceId + "/" + prefix : this.baseDirectory + "/" + spaceId;
        this.log.trace("listing space contents for " + path);
        try {
            return this.listRecursiveFiles(path, co.getConnection());
        }
        catch (IOException e) {
            this.log.error("Could not connect to iRODS", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public List<String> getSpaceContentsChunked(String spaceId, String prefix, long maxResults, String marker) {
        ConnectOperation co = new ConnectOperation(this.host, this.port, this.username, this.password, this.zone);
        ArrayList<String> retList = new ArrayList<String>();
        String spacepath = this.baseDirectory + "/" + spaceId;
        String querypath = prefix != null && !prefix.equals("") ? spacepath + "/" + prefix : spacepath;
        this.log.trace(querypath + " prefix " + prefix + " max " + maxResults + " start " + marker);
        if (maxResults > Integer.MAX_VALUE) {
            throw new StorageException("Cannot return list of size: " + maxResults);
        }
        try {
            QueryBuilder qb = new QueryBuilder(new GenQueryEnum[]{GenQueryEnum.COL_COLL_NAME, GenQueryEnum.COL_DATA_NAME});
            qb.mCmp(GenQueryEnum.COL_COLL_NAME, new QueryBuilder.Condition[]{new QueryBuilder.Condition(QueryBuilder.ConditionType.LIKE, querypath + "/%"), new QueryBuilder.Condition(QueryBuilder.ConditionType.EQ, querypath)});
            this.log.trace("Sending query " + qb);
            QueryResult qr = qb.execute(co.getConnection());
            String markerPath = spaceId + "/" + marker;
            if (marker != null && !marker.equals("")) {
                while (qr.next() && !this.pathMatches(qr, markerPath)) {
                }
            }
            qr.resetReturnCount();
            qr.setMaxReturned((int)maxResults);
            while (qr.next()) {
                String dir = qr.getValue(GenQueryEnum.COL_COLL_NAME);
                String file = qr.getValue(GenQueryEnum.COL_DATA_NAME);
                String resultPath = dir + "/" + file;
                resultPath = resultPath.substring(spacepath.length() + 1);
                retList.add(resultPath);
                this.log.trace("Retrieving path: " + resultPath);
            }
            return retList;
        }
        catch (IOException ex) {
            this.log.error("Error listing directories", (Throwable)ex);
            if (ex instanceof IRodsRequestException && ((IRodsRequestException)ex).getErrorCode() == ErrorEnum.CAT_NO_ROWS_FOUND) {
                return retList;
            }
            throw new StorageException((Throwable)ex);
        }
    }

    private boolean pathMatches(QueryResult qr, String pathSuffix) {
        String dir = qr.getValue(GenQueryEnum.COL_COLL_NAME);
        String file = qr.getValue(GenQueryEnum.COL_DATA_NAME);
        String fullPath = dir + "/" + file;
        return fullPath.endsWith(pathSuffix);
    }

    public void createSpace(String spaceId) {
        ConnectOperation co = new ConnectOperation(this.host, this.port, this.username, this.password, this.zone);
        try {
            IrodsOperations io = new IrodsOperations(co);
            io.mkdir(this.baseDirectory + "/" + spaceId);
            this.log.trace("Created space/directory: " + this.baseDirectory + "/" + spaceId);
        }
        catch (IOException e) {
            this.log.error("Could not connect to iRODS", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteSpace(String spaceId) {
        ConnectOperation co = new ConnectOperation(this.host, this.port, this.username, this.password, this.zone);
        try {
            IrodsOperations io = new IrodsOperations(co);
            io.rmdir(this.baseDirectory + "/" + spaceId, true);
            this.log.trace("Removed space/directory: " + this.baseDirectory + "/" + spaceId);
        }
        catch (IOException e) {
            this.log.error("Could not connect to iRODS", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public Map<String, String> getSpaceProperties(String spaceId) {
        ConnectOperation co = new ConnectOperation(this.host, this.port, this.username, this.password, this.zone);
        try {
            String path = this.baseDirectory + "/" + spaceId;
            Map<String, String> properties = this.getProperties(path, co);
            IrodsOperations ops = new IrodsOperations(co);
            RodsObjStat_PI stat = ops.stat(path);
            properties.put("space-created", this.formattedDate(stat.getModifyTime()));
            properties.put("space-count", "1+");
            return properties;
        }
        catch (IOException e) {
            this.log.error("Could not connect to iRODS", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public Map<String, AclType> getSpaceACLs(String spaceId) {
        throw new UnsupportedOperationException("getSpaceACL not implemented.");
    }

    public void setSpaceACLs(String spaceId, Map<String, AclType> spaceACLs) {
        throw new UnsupportedOperationException("setSpaceACL not implemented.");
    }

    public String addContent(String spaceId, String contentId, String contentMimeType, Map<String, String> userProperties, long contentSize, String contentChecksum, InputStream content) {
        String path = this.baseDirectory + "/" + spaceId + "/" + contentId;
        this.log.trace("Writing to irods path: " + path + " resource: " + this.storageResource);
        ConnectOperation co = new ConnectOperation(this.host, this.port, this.username, this.password, this.zone);
        byte[] buffer = new byte[32768];
        try {
            Object ios = contentSize > 0L ? new IrodsOutputStream(co.getConnection(), path, this.storageResource, contentSize) : new UnknownSizeOutputStream(co.getConnection(), path, this.storageResource, true);
            int read = 0;
            long total = 0L;
            while ((read = content.read(buffer)) > -1) {
                total += (long)read;
                ios.write(buffer, 0, read);
            }
            ios.close();
            this.log.trace("Finished writing irods path: " + path + " resource: " + this.storageResource + " actual read: " + total + " contentSize: " + contentSize);
            if (userProperties != null) {
                MetaDataMap mDataMap = new MetaDataMap(path, co);
                mDataMap.clear();
                for (String e : userProperties.keySet()) {
                    mDataMap.put(e, userProperties.get(e), null);
                }
            }
            return new IrodsOperations(co).stat(path).getChksum();
        }
        catch (IOException e) {
            this.log.error("Error ingesting file", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public String copyContent(String sourceSpaceId, String sourceContentId, String destSpaceId, String destContentId) {
        throw new UnsupportedOperationException("copyContent not implemented");
    }

    public InputStream getContent(String spaceId, String contentId) {
        String path = this.baseDirectory + "/" + spaceId + "/" + contentId;
        ConnectOperation co = new ConnectOperation(this.host, this.port, this.username, this.password, this.zone);
        try {
            ObjTypeEnum type = new IrodsOperations(co).stat(path).getObjType();
            this.log.trace("Opening inputstream to irods path: " + path + " type " + type);
            return new BufferedInputStream((InputStream)new IrodsProxyInputStream(path, co.getConnection()), 32768);
        }
        catch (IOException e) {
            this.log.error("Could not connect to iRODS", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteContent(String spaceId, String contentId) {
        String path = this.baseDirectory + "/" + spaceId + "/" + contentId;
        ConnectOperation co = new ConnectOperation(this.host, this.port, this.username, this.password, this.zone);
        IrodsOperations ops = new IrodsOperations(co);
        try {
            ObjTypeEnum type = ops.stat(path).getObjType();
            if (type != ObjTypeEnum.DATA_OBJ_T) {
                this.log.info("Cannot remove file: " + path + ", type: " + type);
                throw new StorageException("Attempt to remove non-directory path");
            }
            this.log.trace("Removing irods file " + path);
            ops.rm(path);
        }
        catch (IOException e) {
            this.log.error("Could not connect to iRODS", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public void setContentProperties(String spaceId, String contentId, Map<String, String> contentProperties) {
        String path = "spaces".equals(spaceId) ? this.baseDirectory + "/" + contentId : this.baseDirectory + "/" + spaceId + "/" + contentId;
        this.setProperties(path, contentProperties);
    }

    public Map<String, String> getContentProperties(String spaceId, String contentId) {
        String path = "spaces".equals(spaceId) ? this.baseDirectory + "/" + contentId : this.baseDirectory + "/" + spaceId + "/" + contentId;
        ConnectOperation co = new ConnectOperation(this.host, this.port, this.username, this.password, this.zone);
        try {
            Map<String, String> results = this.getProperties(path, co);
            IrodsOperations ops = new IrodsOperations(co);
            RodsObjStat_PI stat = ops.stat(path);
            if (stat != null) {
                results.put("content-modified", this.formattedDate(stat.getModifyTime()));
                results.put("content-size", Long.toString(stat.getObjSize()));
                results.put("content-checksum", stat.getChksum());
                results.put("content-md5", stat.getChksum());
            }
            return results;
        }
        catch (IOException e) {
            this.log.error("Could not connect to iRODS", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    private Iterator<String> listDirectories(String path, IRodsConnection connection) {
        try {
            QueryBuilder qb = new QueryBuilder(new GenQueryEnum[]{GenQueryEnum.COL_COLL_NAME});
            qb.eq(GenQueryEnum.COL_COLL_PARENT_NAME, path);
            this.log.trace("Sending query: " + qb);
            QueryResult qr = qb.execute(connection);
            return new QueryIterator(qr, "", path.length() + 1, GenQueryEnum.COL_COLL_NAME);
        }
        catch (IRodsRequestException ex) {
            this.log.error("Error listing directories", (Throwable)ex);
            if (ex.getErrorCode() == ErrorEnum.CAT_NO_ROWS_FOUND) {
                return new QueryIterator(null, null, 0, new GenQueryEnum[0]);
            }
            throw new StorageException((Throwable)ex);
        }
    }

    private Iterator<String> listRecursiveFiles(String path, IRodsConnection connection) {
        try {
            QueryBuilder qb = new QueryBuilder(new GenQueryEnum[]{GenQueryEnum.COL_COLL_NAME, GenQueryEnum.COL_DATA_NAME});
            qb.mCmp(GenQueryEnum.COL_COLL_NAME, new QueryBuilder.Condition[]{new QueryBuilder.Condition(QueryBuilder.ConditionType.LIKE, path + "/%"), new QueryBuilder.Condition(QueryBuilder.ConditionType.EQ, path)});
            QueryResult qr = qb.execute(connection);
            return new QueryIterator(qr, "/", path.length() + 1, GenQueryEnum.COL_COLL_NAME, GenQueryEnum.COL_DATA_NAME);
        }
        catch (IRodsRequestException ex) {
            this.log.error("Error listing directories", (Throwable)ex);
            if (ex.getErrorCode() == ErrorEnum.CAT_NO_ROWS_FOUND) {
                return new QueryIterator(null, null, 0, new GenQueryEnum[0]);
            }
            throw new StorageException((Throwable)ex);
        }
    }

    private void setProperties(String path, Map<String, String> properties) {
        ConnectOperation co = new ConnectOperation(this.host, this.port, this.username, this.password, this.zone);
        this.log.trace("Writing properties for " + path + " elements: " + properties.size());
        properties.remove("content-modified");
        properties.remove("content-size");
        properties.remove("content-md5");
        properties.remove("content-checksum");
        try {
            MetaDataMap mDataMap = new MetaDataMap(path, co);
            mDataMap.clear();
            for (String e : properties.keySet()) {
                mDataMap.put(e, properties.get(e), null);
            }
        }
        catch (IOException e) {
            this.log.error("Could not connect to iRODS", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    private Map<String, String> getProperties(String path, ConnectOperation co) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            MetaDataMap mDataMap = new MetaDataMap(path, co);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Retrieving properties for " + path + mDataMap);
            }
            for (String e : mDataMap.keySet()) {
                results.put(e, mDataMap.get(e));
            }
            return results;
        }
        catch (IOException e) {
            this.log.error("Could not connect to iRODS", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    private String formattedDate(Date created) {
        ISO8601_DATE_FORMAT.setTimeZone(TimeZone.getDefault());
        return ISO8601_DATE_FORMAT.format(created);
    }

    private String getOptionString(String name, Map<String, String> options) {
        if (!options.containsKey(name) && options.get(name) != null && !options.get(name).equals("")) {
            throw new StorageException("Missing required option: " + name);
        }
        return options.get(name);
    }

    private int getOptionInt(String name, Map<String, String> options) {
        if (!options.containsKey(name)) {
            throw new StorageException("Missing required option: " + name);
        }
        String value = options.get(name);
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            throw new StorageException("Option is not an integer : " + name + " value: " + value);
        }
    }

    private class QueryIterator
    implements Iterator<String> {
        private QueryResult qr;
        private GenQueryEnum[] columns;
        private String seperator;
        private int substr;

        public QueryIterator(QueryResult qr, String seperator, int substr, GenQueryEnum ... columns) {
            this.qr = qr;
            this.columns = columns;
            this.seperator = seperator;
            this.substr = substr;
        }

        @Override
        public boolean hasNext() {
            if (this.qr == null) {
                return false;
            }
            return this.qr.hasNext();
        }

        @Override
        public String next() {
            if (this.qr == null || !this.qr.next()) {
                throw new NoSuchElementException();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.qr.getValue(this.columns[0]));
            for (int i = 1; i < this.columns.length; ++i) {
                sb.append(this.seperator);
                sb.append(this.qr.getValue(this.columns[i]));
            }
            return sb.toString().substring(this.substr);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }
}

