/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.manifest.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.duracloud.manifest.ContentMessage;
import org.duracloud.manifest.ManifestFormatter;
import org.duracloud.manifest.error.ManifestFormatterException;
import org.duracloud.mill.db.model.ManifestItem;
import org.slf4j.Logger;

public abstract class ManifestFormatterBase
implements ManifestFormatter {
    private boolean headerWasWritten = false;

    @Override
    public void writeEventsToOutput(Collection<ContentMessage> events, OutputStream output) {
        this.writeHeader(output);
        Iterator<ContentMessage> itr = events.iterator();
        while (itr.hasNext()) {
            ContentMessage event = itr.next();
            this.write(this.getLine(event), output);
            if (!itr.hasNext()) continue;
            this.write("\n", output);
        }
    }

    @Override
    public void writeManifestItemToOutput(ManifestItem item, OutputStream output) {
        this.writeHeader(output);
        if (item != null) {
            this.write(this.getLine(item), output);
            this.write("\n", output);
        }
    }

    protected void writeHeader(OutputStream output) {
        String header = this.getHeader();
        if (null != header && !this.headerWasWritten) {
            this.write(header + "\n", output);
            this.headerWasWritten = true;
        }
    }

    private void write(String line, OutputStream output) {
        try {
            IOUtils.write((String)line, (OutputStream)output);
        }
        catch (IOException e) {
            StringBuilder err = new StringBuilder("Error writing line: '");
            err.append(line);
            err.append("', error: ");
            err.append(e.getMessage());
            this.log().error(err.toString());
            throw new ManifestFormatterException(err.toString(), e);
        }
    }

    protected abstract Logger log();

    protected abstract String getHeader();

    public String getLine(ContentMessage event) {
        return this.getLine(event.getContentMd5(), event.getSpaceId(), event.getContentId());
    }

    public String getLine(ManifestItem item) {
        return this.getLine(item.getContentChecksum(), item.getSpaceId(), item.getContentId());
    }

    protected abstract String getLine(String var1, String var2, String var3);
}

