/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.manifeststitch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.duracloud.chunk.manifest.ChunksManifest;
import org.duracloud.chunk.manifest.ChunksManifestBean;
import org.duracloud.chunk.manifest.xml.ManifestDocumentBinding;
import org.duracloud.client.ContentStore;
import org.duracloud.common.constant.ManifestFormat;
import org.duracloud.domain.Content;
import org.duracloud.error.ContentStoreException;
import org.duracloud.manifest.ManifestFormatter;
import org.duracloud.manifest.impl.ManifestFormatterFactory;
import org.duracloud.mill.db.model.ManifestItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StitchedManifestGenerator {
    private Logger log = LoggerFactory.getLogger(StitchedManifestGenerator.class);
    private ContentStore store;

    public StitchedManifestGenerator(ContentStore store) {
        this.store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream generate(String spaceId, ManifestFormat format) throws IOException {
        final File stitchedManifestFile = File.createTempFile("stitched-manifest-" + spaceId, "." + format.name().toLowerCase());
        try {
            InputStream manifest = this.store.getManifest(spaceId, format);
            BufferedReader reader = new BufferedReader(new InputStreamReader(manifest));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(stitchedManifestFile)));
            ManifestFormatter formatter = new ManifestFormatterFactory().create(format);
            String header = formatter.getHeader();
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    if (line.trim().length() == 0) continue;
                    if (header != null && line.equals(header)) {
                        this.writeLine(line, writer);
                        continue;
                    }
                    this.processLine(line, formatter, writer);
                }
            }
            catch (IOException e) {
                this.log.error("failed to complete manifest stiching.", (Throwable)e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.log.error("failed to close piped input stream", (Throwable)e);
                }
            }
        }
        catch (ContentStoreException e) {
            this.log.error("failed to generate stitched manifest: " + e.getMessage(), (Throwable)e);
            throw new IOException(e);
        }
        return new AutoCloseInputStream((InputStream)new FileInputStream(stitchedManifestFile){

            @Override
            public void close() throws IOException {
                super.close();
                stitchedManifestFile.delete();
            }
        });
    }

    private void processLine(String line, ManifestFormatter formatter, BufferedWriter writer) throws IOException, ContentStoreException {
        ManifestItem item = null;
        try {
            item = formatter.parseLine(line);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        String contentId = item.getContentId();
        if (contentId.endsWith(".dura-manifest")) {
            this.writeLine(this.processChunkManifest(item, formatter), writer);
        } else {
            if (contentId.contains(".dura-chunk-")) {
                return;
            }
            this.writeLine(line, writer);
        }
    }

    private String processChunkManifest(ManifestItem item, ManifestFormatter formatter) throws ContentStoreException {
        String contentId = item.getContentId();
        String spaceId = item.getSpaceId();
        Content content = this.store.getContent(spaceId, contentId);
        ChunksManifest chunkManifest = ManifestDocumentBinding.createManifestFrom((InputStream)content.getStream());
        ChunksManifestBean.ManifestHeader header = chunkManifest.getHeader();
        String checksum = header.getSourceMD5();
        String newContentId = header.getSourceContentId();
        ManifestItem newItem = new ManifestItem();
        newItem.setSpaceId(spaceId);
        newItem.setContentId(newContentId);
        newItem.setContentChecksum(checksum);
        return formatter.formatLine(newItem);
    }

    protected void writeLine(String line, BufferedWriter writer) throws IOException {
        writer.write(line);
        writer.newLine();
    }
}

