/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.manifest.jpa;

import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import org.duracloud.common.collection.IteratorSource;
import org.duracloud.common.collection.StreamingIterator;
import org.duracloud.error.NotFoundException;
import org.duracloud.mill.db.model.ManifestItem;
import org.duracloud.mill.db.repo.JpaManifestItemRepo;
import org.duracloud.mill.db.util.JpaIteratorSource;
import org.duracloud.mill.manifest.ManifestItemWriteException;
import org.duracloud.mill.manifest.ManifestStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

@Transactional(value="millJpaRepoTransactionManager")
public class JpaManifestStore
implements ManifestStore {
    private static Logger log = LoggerFactory.getLogger(JpaManifestStore.class);
    private JpaManifestItemRepo manifestItemRepo;

    @Autowired
    public JpaManifestStore(JpaManifestItemRepo manifestItemRepo) {
        this.manifestItemRepo = manifestItemRepo;
    }

    @Override
    public void addUpdate(String account, String storeId, String spaceId, String contentId, String contentChecksum, String contentMimetype, String contentSize, Date eventTimestamp) throws ManifestItemWriteException {
        if (log.isDebugEnabled()) {
            log.debug("preparing to write account={}, storeId={}, spaceId={}, contentId={}, contentChecksum={}, contentMimetype={}, contentSize={}, eventTimestamp={}", new Object[]{account, storeId, spaceId, contentId, contentChecksum, contentMimetype, contentSize, eventTimestamp});
        }
        try {
            boolean save = false;
            ManifestItem item = this.manifestItemRepo.findByAccountAndStoreIdAndSpaceIdAndContentId(account, storeId, spaceId, contentId);
            String action = "added";
            if (item != null) {
                String oldMimetype;
                String oldChecksum;
                if (this.eventOutOfOrder(item, eventTimestamp)) {
                    return;
                }
                if (item.isDeleted()) {
                    item.setDeleted(false);
                    save = true;
                }
                if (!(oldChecksum = item.getContentChecksum()).equals(contentChecksum)) {
                    log.info("content checksum changed from {} to {}", (Object)oldChecksum, (Object)contentChecksum);
                    save = true;
                }
                if (!(oldMimetype = item.getContentMimetype()).equals(contentMimetype)) {
                    log.info("content mimetype changed from {} to {}", (Object)oldMimetype, (Object)contentMimetype);
                    save = true;
                }
                action = "updated";
            } else {
                item = new ManifestItem();
                item.setAccount(account);
                item.setStoreId(storeId);
                item.setSpaceId(spaceId);
                item.setContentId(contentId);
                save = true;
            }
            if (save) {
                item.setContentChecksum(contentChecksum);
                item.setContentMimetype(contentMimetype);
                item.setContentSize(contentSize);
                item.setModified(eventTimestamp);
                ManifestItem result = (ManifestItem)this.manifestItemRepo.saveAndFlush(item);
                log.info("successfully {} {} to the jpa repo.", (Object)action, (Object)result);
            } else {
                log.info("no update necessary since no changes were detected for {}", (Object)item);
            }
        }
        catch (Exception ex) {
            String message = "failed to write item: " + ex.getMessage();
            log.error(message);
            throw new ManifestItemWriteException(message, ex);
        }
    }

    @Override
    public void flagAsDeleted(String account, String storeId, String spaceId, String contentId, Date eventTimestamp) throws ManifestItemWriteException {
        try {
            ManifestItem item = this.manifestItemRepo.findByAccountAndStoreIdAndSpaceIdAndContentId(account, storeId, spaceId, contentId);
            if (item != null) {
                if (this.eventOutOfOrder(item, eventTimestamp)) {
                    return;
                }
                if (item.isDeleted()) {
                    log.warn("item {}/{}/{}/{} has already been deleted - there appears to have been a duplicate event or possibly a missed content add event - ignoring...", new Object[]{account, storeId, spaceId, contentId});
                } else {
                    item.setDeleted(true);
                }
                item.setModified(eventTimestamp);
                ManifestItem result = (ManifestItem)this.manifestItemRepo.saveAndFlush(item);
                log.info("successfully processed flag as deleted: {}", (Object)result);
            } else {
                log.warn("no manifest item {}/{}/{}/{} : nothing to delete - ignoring...", new Object[]{account, storeId, spaceId, contentId});
            }
        }
        catch (Exception ex) {
            String message = "failed to flag item as deleted item: " + ex.getMessage();
            log.error(message);
            throw new ManifestItemWriteException(message, ex);
        }
    }

    private boolean eventOutOfOrder(ManifestItem item, Date eventTimestamp) {
        Date itemTimestamp = item.getModified();
        if (eventTimestamp.before(itemTimestamp)) {
            log.warn("The current database item is more current that the event: item last modified: {}, event timestamp: {}. Likely cause: events were delivered out of order. Ignoring...", (Object)itemTimestamp, (Object)eventTimestamp);
            return true;
        }
        return false;
    }

    @Override
    @Transactional(readOnly=true, value="millJpaRepoTransactionManager")
    public Iterator<ManifestItem> getItems(final String account, final String storeId, final String spaceId) {
        JpaIteratorSource<JpaManifestItemRepo, ManifestItem> source = new JpaIteratorSource<JpaManifestItemRepo, ManifestItem>(this.manifestItemRepo){

            @Override
            protected Page<ManifestItem> getNextPage(Pageable pageable, JpaManifestItemRepo repo) {
                return JpaManifestStore.this.manifestItemRepo.findByAccountAndStoreIdAndSpaceIdAndDeletedFalseOrderByContentIdAsc(account, storeId, spaceId, pageable);
            }
        };
        return new StreamingIterator((IteratorSource)source);
    }

    @Override
    public ManifestItem getItem(String account, String storeId, String spaceId, String contentId) throws NotFoundException {
        ManifestItem item = this.manifestItemRepo.findByAccountAndStoreIdAndSpaceIdAndContentId(account, storeId, spaceId, contentId);
        if (item == null) {
            throw new NotFoundException(MessageFormat.format("No ManifestItem could be found matching the specified params: account={0}, storeId={1}, spaceId={2}, contentId={3}", account, storeId, spaceId, contentId));
        }
        return item;
    }

    @Override
    public Long purgeDeletedItemsBefore(Date expiration) {
        return this.manifestItemRepo.deleteByDeletedTrueAndModifiedBefore(expiration);
    }

    @Override
    public void updateMissingFromStorageProviderFlag(String account, String storeId, String spaceId, String contentId, boolean flag) throws ManifestItemWriteException {
        try {
            ManifestItem item = this.manifestItemRepo.findByAccountAndStoreIdAndSpaceIdAndContentId(account, storeId, spaceId, contentId);
            if (item == null) {
                String message = MessageFormat.format("no manifest item found:  {0}/{1}/{2}/{3}: something's amiss.", account, storeId, spaceId, contentId);
                throw new NotFoundException(message);
            }
            item.setMissingFromStorageProvider(flag);
            ManifestItem result = (ManifestItem)this.manifestItemRepo.saveAndFlush(item);
            log.info("successfully processed update MissingFromStorageProvider flag: {}", (Object)result);
        }
        catch (Exception ex) {
            String message = "failed to update manifest item with : " + ex.getMessage();
            log.error(message);
            throw new ManifestItemWriteException(message, ex);
        }
    }
}

