/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.db.repo;

import java.text.MessageFormat;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.duracloud.mill.db.repo.JpaManifestItemRepo;
import org.duracloud.mill.manifest.ManifestStore;
import org.duracloud.mill.manifest.jpa.JpaManifestStore;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableJpaRepositories(basePackages={"org.duracloud.mill"}, entityManagerFactoryRef="millRepoEntityManagerFactory", transactionManagerRef="millJpaRepoTransactionManager")
@EnableTransactionManagement
public class MillJpaRepoConfig {
    private static final String MILL_REPO_ENTITY_MANAGER_FACTORY_BEAN = "millRepoEntityManagerFactory";
    public static final String MILL_REPO_DATA_SOURCE_BEAN = "millRepoDataSource";
    public static final String TRANSACTION_MANAGER_BEAN = "millJpaRepoTransactionManager";
    public static final String ENTITY_MANAGER_FACTORY_BEAN = "millRepoEntityManagerFactory";

    @Bean(name={"millRepoDataSource"}, destroyMethod="close")
    public BasicDataSource millRepoDataSource() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName("com.mysql.jdbc.Driver");
        dataSource.setUrl(MessageFormat.format("jdbc:mysql://{0}:{1}/{2}?autoReconnect=true&characterEncoding=utf8&characterSetResults=utf8", System.getProperty("mill.db.host", "localhost"), System.getProperty("mill.db.port", "3306"), System.getProperty("mill.db.name", "mill")));
        dataSource.setUsername(System.getProperty("mill.db.user", "mill"));
        dataSource.setPassword(System.getProperty("mill.db.pass", "password"));
        return dataSource;
    }

    @Bean(name={"millJpaRepoTransactionManager"})
    public PlatformTransactionManager millRepoTransactionManager(@Qualifier(value="millRepoEntityManagerFactory") EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager tm = new JpaTransactionManager(entityManagerFactory);
        tm.setJpaDialect((JpaDialect)new HibernateJpaDialect());
        return tm;
    }

    @Bean(name={"millRepoEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean millRepoEntityManagerFactory(@Qualifier(value="millRepoDataSource") DataSource dataSource) {
        LocalContainerEntityManagerFactoryBean emf = new LocalContainerEntityManagerFactoryBean();
        emf.setDataSource(dataSource);
        emf.setPersistenceUnitName("mill-repo-pu");
        emf.setPackagesToScan(new String[]{"org.duracloud.mill"});
        String hbm2ddlAuto = System.getProperty("hibernate.hbm2ddl.auto");
        HibernateJpaVendorAdapter va = new HibernateJpaVendorAdapter();
        va.setGenerateDdl(hbm2ddlAuto != null);
        va.setDatabase(Database.MYSQL);
        emf.setJpaVendorAdapter((JpaVendorAdapter)va);
        Properties props = new Properties();
        if (hbm2ddlAuto != null) {
            props.setProperty("hibernate.hbm2ddl.auto", hbm2ddlAuto);
        }
        props.setProperty("hibernate.dialect", "org.hibernate.dialect.MySQL5Dialect");
        props.setProperty("hibernate.ejb.naming_strategy", "org.hibernate.cfg.ImprovedNamingStrategy");
        props.setProperty("hibernate.cache.provider_class", "org.hibernate.cache.HashtableCacheProvider");
        props.setProperty("jadira.usertype.autoRegisterUserTypes", "true");
        props.setProperty("jadira.usertype.databaseZone", "jvm");
        props.setProperty("hibernate.show_sql", "false");
        props.setProperty("hibernate.format_sql", "false");
        props.setProperty("hibernate.show_comments", "false");
        emf.setJpaProperties(props);
        return emf;
    }

    @Bean
    public ManifestStore manifestStore(JpaManifestItemRepo manifestRepo) {
        return new JpaManifestStore(manifestRepo);
    }
}

