/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.audit.taskgenerator;

import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManagerImpl;
import org.duracloud.common.model.Credential;
import org.duracloud.mill.audit.taskgenerator.AuditTaskGenerator;
import org.duracloud.mill.util.DriverSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditTaskGeneratorDriver
extends DriverSupport {
    private static Logger log = LoggerFactory.getLogger(AuditTaskGeneratorDriver.class);

    public AuditTaskGeneratorDriver() {
        super(new AuditTaskGeneratorOptions());
    }

    public static void main(String[] args) {
        new AuditTaskGeneratorDriver().execute(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeImpl(CommandLine cmd) {
        try {
            boolean dryRun = cmd.hasOption("d");
            String host = cmd.getOptionValue("host");
            String port = cmd.getOptionValue("port", "443");
            String username = cmd.getOptionValue("u");
            String password = cmd.getOptionValue("p");
            String spaceId = cmd.getOptionValue("s");
            String storeId = cmd.getOptionValue("t");
            String auditQueueName = cmd.getOptionValue("q");
            String account = host.split("[.]")[0];
            ContentStoreManagerImpl storeManager = new ContentStoreManagerImpl(host, port);
            storeManager.login(new Credential(username, password));
            Map<String, ContentStore> contentStoreMap = storeManager.getContentStores();
            ContentStore store = storeId != null ? storeManager.getContentStore(storeId) : storeManager.getPrimaryContentStore();
            AuditTaskGenerator generator = new AuditTaskGenerator(store, spaceId, dryRun, account, auditQueueName, username);
            generator.execute();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        finally {
            log.info("exiting...");
        }
    }

    private static class AuditTaskGeneratorOptions
    extends Options {
        public AuditTaskGeneratorOptions() {
            this.addOption("u", "username", true, "DuraCloud username");
            this.addOption("p", "password", true, "DuraCloud password");
            this.addOption("h", "host", true, "DuraCloud host");
            this.addOption("r", "port", true, "DuraCloud port: 443 by default", false);
            this.addOption("s", "space", true, "The space ID", true);
            this.addOption("t", "store-id", true, "The storage provider ID", false);
            this.addOption("q", "audit-queue", true, "AWS SQS Queue Name");
            this.addOption("d", "dry-run", false, "Do not put tasks on the queue - only show what tasks will be added.", false);
        }

        @Override
        public Options addOption(String opt, String longOpt, boolean hasArg, String description) {
            return this.addOption(opt, longOpt, hasArg, description, true);
        }

        public Options addOption(String opt, String longOpt, boolean hasArg, String description, boolean required) {
            Option option = new Option(opt, longOpt, hasArg, description);
            option.setRequired(required);
            return super.addOption(option);
        }
    }
}

