/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task.streaming;

import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentity;
import com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig;
import com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentitySummary;
import com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import com.amazonaws.services.cloudfront.model.S3Origin;
import com.amazonaws.services.cloudfront.model.StreamingDistribution;
import com.amazonaws.services.cloudfront.model.StreamingDistributionConfig;
import com.amazonaws.services.cloudfront.model.StreamingDistributionSummary;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import com.amazonaws.services.s3.AmazonS3;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3storageprovider.dto.EnableStreamingTaskParameters;
import org.duracloud.s3storageprovider.dto.EnableStreamingTaskResult;
import org.duracloud.s3task.streaming.BaseStreamingTaskRunner;
import org.duracloud.storage.error.UnsupportedTaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnableStreamingTaskRunner
extends BaseStreamingTaskRunner {
    private final Logger log = LoggerFactory.getLogger(EnableStreamingTaskRunner.class);
    private static final String TASK_NAME = "enable-streaming";

    public EnableStreamingTaskRunner(StorageProvider s3Provider, S3StorageProvider unwrappedS3Provider, AmazonS3 s3Client, AmazonCloudFrontClient cfClient, String cfAccountId) {
        this.s3Provider = s3Provider;
        this.unwrappedS3Provider = unwrappedS3Provider;
        this.s3Client = s3Client;
        this.cfClient = cfClient;
        this.cfAccountId = cfAccountId;
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public String performTask(String taskParameters) {
        EnableStreamingTaskParameters taskParams = EnableStreamingTaskParameters.deserialize(taskParameters);
        String spaceId = taskParams.getSpaceId();
        boolean secure = taskParams.isSecure();
        this.log.info("Performing enable-streaming task on space " + spaceId + ". Secure streaming set to " + secure);
        String bucketName = this.unwrappedS3Provider.getBucketName(spaceId);
        String domainName = null;
        String distId = null;
        String oaIdentityId = this.getOriginAccessId();
        EnableStreamingTaskResult taskResult = new EnableStreamingTaskResult();
        StreamingDistributionSummary existingDist = this.getExistingDistribution(bucketName);
        if (existingDist != null) {
            boolean existingSecure;
            boolean bl = existingSecure = !existingDist.getTrustedSigners().getItems().isEmpty();
            if (secure && !existingSecure || !secure && existingSecure) {
                throw new UnsupportedTaskException(TASK_NAME, "The space " + spaceId + " is already configured to stream as " + (secure ? "OPEN" : "SECURE") + " and cannot be updated to stream as " + (secure ? "SECURE" : "OPEN") + ". To do this, you must first execute the " + "delete-streaming" + " task.");
            }
            distId = existingDist.getId();
            if (!existingDist.isEnabled().booleanValue()) {
                this.setDistributionState(distId, true);
            }
            domainName = existingDist.getDomainName();
        } else {
            S3Origin origin = new S3Origin(bucketName + ".s3.amazonaws.com", "origin-access-identity/cloudfront/" + oaIdentityId);
            TrustedSigners signers = new TrustedSigners();
            if (secure) {
                signers.setItems(Collections.singletonList(this.cfAccountId));
                signers.setEnabled(true);
                signers.setQuantity(1);
            } else {
                signers.setEnabled(false);
                signers.setQuantity(0);
            }
            StreamingDistribution dist = this.cfClient.createStreamingDistribution(new CreateStreamingDistributionRequest(new StreamingDistributionConfig().withCallerReference("" + System.currentTimeMillis()).withS3Origin(origin).withEnabled(true).withComment("Streaming space: " + spaceId).withTrustedSigners(signers))).getStreamingDistribution();
            domainName = dist.getDomainName();
        }
        this.setBucketAccessPolicy(bucketName, oaIdentityId);
        Map<String, String> spaceProps = this.s3Provider.getSpaceProperties(spaceId);
        spaceProps.put("streaming-host", domainName);
        spaceProps.put("streaming-type", secure ? BaseStreamingTaskRunner.STREAMING_TYPE.SECURE.name() : BaseStreamingTaskRunner.STREAMING_TYPE.OPEN.name());
        this.unwrappedS3Provider.setNewSpaceProperties(spaceId, spaceProps);
        taskResult.setResult("Enable Streaming Task completed successfully");
        taskResult.setStreamingHost(domainName);
        String toReturn = taskResult.serialize();
        this.log.info("Result of enable-streaming task: " + toReturn);
        return toReturn;
    }

    private String getOriginAccessId() {
        String oaId = this.getExistingOriginAccessId();
        if (oaId != null) {
            return oaId;
        }
        return this.cfClient.createCloudFrontOriginAccessIdentity(new CreateCloudFrontOriginAccessIdentityRequest(new CloudFrontOriginAccessIdentityConfig().withCallerReference("" + System.currentTimeMillis()).withComment("DuraCloud Origin Access ID"))).getCloudFrontOriginAccessIdentity().getId();
    }

    private String getExistingOriginAccessId() {
        List<CloudFrontOriginAccessIdentitySummary> oaiList = this.cfClient.listCloudFrontOriginAccessIdentities(new ListCloudFrontOriginAccessIdentitiesRequest()).getCloudFrontOriginAccessIdentityList().getItems();
        if (oaiList != null && oaiList.size() > 0) {
            return oaiList.iterator().next().getId();
        }
        return null;
    }

    private void setBucketAccessPolicy(String bucketName, String oaIdentityId) {
        CloudFrontOriginAccessIdentity cfOAIdentity = this.cfClient.getCloudFrontOriginAccessIdentity(new GetCloudFrontOriginAccessIdentityRequest(oaIdentityId)).getCloudFrontOriginAccessIdentity();
        String s3UserId = cfOAIdentity.getS3CanonicalUserId();
        StringBuilder policyText = new StringBuilder();
        policyText.append("{\"Version\":\"2012-10-17\",");
        policyText.append("\"Id\":\"PolicyForCloudFrontPrivateContent\",");
        policyText.append("\"Statement\":[{");
        policyText.append("\"Sid\":\"Grant CloudFront access to private content\",");
        policyText.append("\"Effect\":\"Allow\",");
        policyText.append("\"Principal\":{\"CanonicalUser\":\"" + s3UserId + "\"},");
        policyText.append("\"Action\":\"s3:GetObject\",");
        policyText.append("\"Resource\":\"arn:aws:s3:::" + bucketName + "/*\"");
        policyText.append("}]}");
        this.s3Client.setBucketPolicy(bucketName, policyText.toString());
    }
}

