/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.audit.taskgenerator;

import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.duracloud.audit.task.AuditTask;
import org.duracloud.client.ContentStore;
import org.duracloud.common.queue.aws.SQSTaskQueue;
import org.duracloud.common.queue.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditTaskGenerator {
    private static final Logger log = LoggerFactory.getLogger(AuditTaskGenerator.class);
    private static final SimpleDateFormat ISO_DATETIME = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private ContentStore contentStore;
    private String spaceId;
    private String account;
    private boolean dryRun;
    private int totalAuditTasksAddedToQueue = 0;
    private String auditQueueName;
    private String username;

    public AuditTaskGenerator(ContentStore contentStore, String spaceId, boolean dryRun, String account, String auditQueueName, String username) {
        this.contentStore = contentStore;
        this.dryRun = dryRun;
        this.spaceId = spaceId;
        this.account = account;
        this.auditQueueName = auditQueueName;
        this.username = username;
    }

    public void execute() throws Exception {
        long startTime = System.currentTimeMillis();
        SQSTaskQueue queue = new SQSTaskQueue(this.auditQueueName);
        log.info("Created task queue for queue " + this.auditQueueName);
        String storeId = this.contentStore.getStoreId();
        Iterator<String> contentIds = this.contentStore.getSpaceContents(this.spaceId);
        while (contentIds.hasNext()) {
            String contentId = contentIds.next();
            Map<String, String> props = this.contentStore.getContentProperties(this.spaceId, contentId);
            AuditTask task = new AuditTask();
            task.setAction(AuditTask.ActionType.ADD_CONTENT.name());
            task.setUserId(this.username);
            task.setDateTime("" + this.toEpochMilliseconds(props.get("content-modified")));
            task.setAccount(this.account);
            task.setStoreId(this.contentStore.getStoreId());
            task.setStoreType(this.contentStore.getStorageProviderType());
            task.setSpaceId(this.spaceId);
            task.setSpaceACLs(null);
            task.setContentId(contentId);
            task.setContentChecksum(props.get("content-checksum"));
            task.setContentMimetype(props.get("content-mimetype"));
            task.setContentSize(props.get("content-size"));
            task.setContentProperties(props);
            Task writeTask = task.writeTask();
            if (!this.dryRun) {
                queue.put(writeTask);
                log.info("Wrote {} to {}", (Object)writeTask.toString(), (Object)this.auditQueueName);
            } else {
                log.info("Dry Run -> Ignored: write {} to {}", (Object)writeTask.toString(), (Object)this.auditQueueName);
            }
            ++this.totalAuditTasksAddedToQueue;
        }
        String duration = DurationFormatUtils.formatDurationHMS(System.currentTimeMillis() - startTime);
        log.info("audit task generation complete for account={},  spaceId={} : duration={} total_audit_tasks_added_to_queue={}", this.account, this.spaceId, duration, this.totalAuditTasksAddedToQueue);
    }

    private long toEpochMilliseconds(String dateStr) throws Exception {
        long modifiedInMs = dateStr != null ? ISO_DATETIME.parse(dateStr).getTime() : System.currentTimeMillis();
        return modifiedInMs;
    }
}

