/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudfront.model.CreateKeyGroupRequest;
import com.amazonaws.services.cloudfront.model.KeyGroupConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class CreateKeyGroupRequestMarshaller
implements Marshaller<Request<CreateKeyGroupRequest>, CreateKeyGroupRequest> {
    @Override
    public Request<CreateKeyGroupRequest> marshall(CreateKeyGroupRequest createKeyGroupRequest) {
        if (createKeyGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateKeyGroupRequest> request = new DefaultRequest<CreateKeyGroupRequest>(createKeyGroupRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2020-05-31/key-group";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            KeyGroupConfig keyGroupConfig = createKeyGroupRequest.getKeyGroupConfig();
            if (keyGroupConfig != null) {
                SdkInternalList keyGroupConfigItemsList;
                xmlWriter.startElement("KeyGroupConfig");
                if (keyGroupConfig.getName() != null) {
                    xmlWriter.startElement("Name").value(keyGroupConfig.getName()).endElement();
                }
                if (!(keyGroupConfigItemsList = (SdkInternalList)keyGroupConfig.getItems()).isEmpty() || !keyGroupConfigItemsList.isAutoConstruct()) {
                    xmlWriter.startElement("Items");
                    for (String keyGroupConfigItemsListValue : keyGroupConfigItemsList) {
                        xmlWriter.startElement("PublicKey");
                        xmlWriter.value(keyGroupConfigItemsListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (keyGroupConfig.getComment() != null) {
                    xmlWriter.startElement("Comment").value(keyGroupConfig.getComment()).endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

