/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.CreateOriginAccessControlRequest;
import com.amazonaws.services.cloudfront.model.OriginAccessControlConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class CreateOriginAccessControlRequestMarshaller
implements Marshaller<Request<CreateOriginAccessControlRequest>, CreateOriginAccessControlRequest> {
    @Override
    public Request<CreateOriginAccessControlRequest> marshall(CreateOriginAccessControlRequest createOriginAccessControlRequest) {
        if (createOriginAccessControlRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateOriginAccessControlRequest> request = new DefaultRequest<CreateOriginAccessControlRequest>(createOriginAccessControlRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2020-05-31/origin-access-control";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2020-05-31/");
            OriginAccessControlConfig originAccessControlConfig = createOriginAccessControlRequest.getOriginAccessControlConfig();
            if (originAccessControlConfig != null) {
                xmlWriter.startElement("OriginAccessControlConfig");
                if (originAccessControlConfig.getName() != null) {
                    xmlWriter.startElement("Name").value(originAccessControlConfig.getName()).endElement();
                }
                if (originAccessControlConfig.getDescription() != null) {
                    xmlWriter.startElement("Description").value(originAccessControlConfig.getDescription()).endElement();
                }
                if (originAccessControlConfig.getSigningProtocol() != null) {
                    xmlWriter.startElement("SigningProtocol").value(originAccessControlConfig.getSigningProtocol()).endElement();
                }
                if (originAccessControlConfig.getSigningBehavior() != null) {
                    xmlWriter.startElement("SigningBehavior").value(originAccessControlConfig.getSigningBehavior()).endElement();
                }
                if (originAccessControlConfig.getOriginAccessControlOriginType() != null) {
                    xmlWriter.startElement("OriginAccessControlOriginType").value(originAccessControlConfig.getOriginAccessControlOriginType()).endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

