/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.ImportSource;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ImportSourceStaxUnmarshaller
implements Unmarshaller<ImportSource, StaxUnmarshallerContext> {
    private static ImportSourceStaxUnmarshaller instance;

    @Override
    public ImportSource unmarshall(StaxUnmarshallerContext context) throws Exception {
        ImportSource importSource = new ImportSource();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return importSource;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SourceType", targetDepth)) {
                    importSource.setSourceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SourceARN", targetDepth)) continue;
                importSource.setSourceARN(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return importSource;
    }

    public static ImportSourceStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ImportSourceStaxUnmarshaller();
        }
        return instance;
    }
}

