/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.ListFunctionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListFunctionsRequestMarshaller
implements Marshaller<Request<ListFunctionsRequest>, ListFunctionsRequest> {
    @Override
    public Request<ListFunctionsRequest> marshall(ListFunctionsRequest listFunctionsRequest) {
        if (listFunctionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListFunctionsRequest> request = new DefaultRequest<ListFunctionsRequest>(listFunctionsRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2020-05-31/function";
        request.setResourcePath(uriResourcePath);
        if (listFunctionsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listFunctionsRequest.getMarker()));
        }
        if (listFunctionsRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromString(listFunctionsRequest.getMaxItems()));
        }
        if (listFunctionsRequest.getStage() != null) {
            request.addParameter("Stage", StringUtils.fromString(listFunctionsRequest.getStage()));
        }
        return request;
    }
}

