/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.OriginGroup;
import com.amazonaws.services.cloudfront.model.OriginGroups;
import com.amazonaws.services.cloudfront.model.transform.OriginGroupStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class OriginGroupsStaxUnmarshaller
implements Unmarshaller<OriginGroups, StaxUnmarshallerContext> {
    private static OriginGroupsStaxUnmarshaller instance;

    @Override
    public OriginGroups unmarshall(StaxUnmarshallerContext context) throws Exception {
        OriginGroups originGroups = new OriginGroups();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return originGroups;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    originGroups.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    originGroups.withItems(new ArrayList<OriginGroup>());
                    continue;
                }
                if (!context.testExpression("Items/OriginGroup", targetDepth)) continue;
                originGroups.withItems(OriginGroupStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return originGroups;
    }

    public static OriginGroupsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new OriginGroupsStaxUnmarshaller();
        }
        return instance;
    }
}

