/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.resilience;

import org.ehcache.Cache;
import org.ehcache.CacheIterationException;
import org.ehcache.core.spi.time.SystemTimeSource;
import org.ehcache.impl.internal.util.Pacer;
import org.ehcache.spi.resilience.RecoveryStore;
import org.ehcache.spi.resilience.ResilienceStrategy;
import org.ehcache.spi.resilience.StoreAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResilienceStrategy<K, V>
implements ResilienceStrategy<K, V> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final RecoveryStore<K> store;
    private final Pacer pacer = new Pacer(SystemTimeSource.INSTANCE, 30000L);

    protected AbstractResilienceStrategy(RecoveryStore<K> store) {
        this.store = store;
    }

    @Override
    public Cache.Entry<K, V> iteratorFailure(StoreAccessException e) {
        this.LOGGER.error("Ehcache iterator terminated early due to exception", e);
        throw new CacheIterationException(e);
    }

    protected void cleanup(StoreAccessException from) {
        try {
            this.store.obliterate();
        }
        catch (StoreAccessException e) {
            this.inconsistent(from, e);
            return;
        }
        this.recovered(from);
    }

    protected void cleanup(Iterable<? extends K> keys, StoreAccessException from) {
        try {
            this.store.obliterate(keys);
        }
        catch (StoreAccessException e) {
            this.inconsistent(keys, from, e);
            return;
        }
        this.recovered(keys, from);
    }

    protected void cleanup(K key, StoreAccessException from) {
        try {
            this.store.obliterate(key);
        }
        catch (StoreAccessException e) {
            this.inconsistent(key, from, e);
            return;
        }
        this.recovered(key, from);
    }

    protected void recovered(K key, StoreAccessException from) {
        this.LOGGER.info("Ehcache key {} recovered from", (Object)key, (Object)from);
    }

    protected void recovered(Iterable<? extends K> keys, StoreAccessException from) {
        this.LOGGER.info("Ehcache keys {} recovered from", (Object)keys, (Object)from);
    }

    protected void recovered(StoreAccessException from) {
        this.LOGGER.info("Ehcache recovered from", from);
    }

    protected void inconsistent(K key, StoreAccessException because, StoreAccessException ... cleanup) {
        this.pacedErrorLog("Ehcache key {} in possible inconsistent state", key, because);
    }

    protected void inconsistent(Iterable<? extends K> keys, StoreAccessException because, StoreAccessException ... cleanup) {
        this.pacedErrorLog("Ehcache keys {} in possible inconsistent state", keys, because);
    }

    protected void inconsistent(StoreAccessException because, StoreAccessException ... cleanup) {
        this.pacedErrorLog("Ehcache in possible inconsistent state", because);
    }

    protected void pacedErrorLog(String message, StoreAccessException e) {
        this.pacer.pacedCall(() -> this.LOGGER.error(message + " - Similar messages will be suppressed for 30 seconds", e), () -> this.LOGGER.debug(message, e));
    }

    protected void pacedErrorLog(String message, Object arg1, Object arg2) {
        this.pacer.pacedCall(() -> this.LOGGER.error(message + " - Similar messages will be suppressed for 30 seconds", arg1, arg2), () -> this.LOGGER.debug(message, arg1, arg2));
    }
}

