/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.mill.audit.generator;

import java.util.List;
import org.duracloud.mill.audit.generator.LogManager;
import org.duracloud.mill.db.model.JpaAuditLogItem;
import org.duracloud.mill.db.repo.JpaAuditLogItemRepo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditLogGenerator {
    private static Logger log = LoggerFactory.getLogger(AuditLogGenerator.class);
    private JpaAuditLogItemRepo auditLogItemRepo;
    private LogManager logManager;

    @Autowired
    public AuditLogGenerator(JpaAuditLogItemRepo auditLogItemRepo, LogManager logManager) {
        this.auditLogItemRepo = auditLogItemRepo;
        this.logManager = logManager;
    }

    public void execute() {
        log.info("executing generator...");
        long itemsWritten = 0L;
        try {
            List<JpaAuditLogItem> items;
            do {
                if (CollectionUtils.isEmpty(items = this.auditLogItemRepo.findTop10000ByWrittenFalseOrderByTimestampAsc())) {
                    log.info("No audit items found for processing: nowhere to go, nothing to do.", (Object)items.size());
                    break;
                }
                log.info("{} audit items read from the the jpa repo.", (Object)items.size());
                for (JpaAuditLogItem item : items) {
                    this.write(item);
                }
                log.info("{} audit items written.", (Object)items.size());
            } while ((itemsWritten += (long)items.size()) < 1000000L);
            log.info("{} total audit items written in this run.", (Object)itemsWritten);
            this.logManager.purgeExpired();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        finally {
            try {
                this.logManager.flushLogs();
                log.info("audit log run completed successfully.");
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), ex);
                throw new RuntimeException(ex);
            }
        }
    }

    private void write(JpaAuditLogItem item) {
        this.logManager.write(item);
    }
}

