/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.s3task;

import com.amazonaws.services.cloudfront.AmazonCloudFrontClient;
import com.amazonaws.services.s3.AmazonS3Client;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.s3task.NoopTaskRunner;
import org.duracloud.s3task.storage.SetStoragePolicyTaskRunner;
import org.duracloud.s3task.streaming.DeleteStreamingTaskRunner;
import org.duracloud.s3task.streaming.DisableStreamingTaskRunner;
import org.duracloud.s3task.streaming.EnableStreamingTaskRunner;
import org.duracloud.s3task.streaming.GetSignedUrlTaskRunner;
import org.duracloud.s3task.streaming.GetUrlTaskRunner;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.provider.TaskProviderBase;
import org.slf4j.LoggerFactory;

public class S3TaskProvider
extends TaskProviderBase {
    public S3TaskProvider(StorageProvider s3Provider, S3StorageProvider unwrappedS3Provider, AmazonS3Client s3Client, AmazonCloudFrontClient cfClient, String cfAccountId, String cfKeyId, String cfKeyPath) {
        this.log = LoggerFactory.getLogger(S3TaskProvider.class);
        this.taskList.add(new NoopTaskRunner());
        this.taskList.add(new EnableStreamingTaskRunner(s3Provider, unwrappedS3Provider, s3Client, cfClient, cfAccountId));
        this.taskList.add(new GetUrlTaskRunner(s3Provider, unwrappedS3Provider, cfClient));
        this.taskList.add(new GetSignedUrlTaskRunner(s3Provider, unwrappedS3Provider, cfClient, cfKeyId, cfKeyPath));
        this.taskList.add(new DisableStreamingTaskRunner(s3Provider, unwrappedS3Provider, s3Client, cfClient));
        this.taskList.add(new DeleteStreamingTaskRunner(s3Provider, unwrappedS3Provider, s3Client, cfClient));
        this.taskList.add(new SetStoragePolicyTaskRunner(unwrappedS3Provider));
    }
}

