/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteStreams;
import com.google.common.reflect.Invokable;
import com.google.inject.Provider;
import java.io.IOException;
import java.security.InvalidKeyException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Macs;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.options.GetOptions;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.TemporaryUrlKey;
import org.jclouds.openstack.swift.blobstore.functions.BlobToObject;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.util.Strings2;

@Singleton
public class SwiftBlobSigner<T extends CommonSwiftAsyncClient>
implements BlobRequestSigner {
    private final Function<Invocation, HttpRequest> processor;
    private final Crypto crypto;
    private final Provider<Long> unixEpochTimestampProvider;
    private final Supplier<String> temporaryUrlKeySupplier;
    private final BlobToObject blobToObject;
    private final BlobToHttpGetOptions blob2HttpGetOptions;
    private final Invokable<?, ?> getMethod;
    private final Invokable<?, ?> deleteMethod;
    private final Invokable<?, ?> createMethod;

    @Inject
    protected SwiftBlobSigner(BlobToObject blobToObject, BlobToHttpGetOptions blob2HttpGetOptions, Crypto crypto, @TimeStamp Provider<Long> unixEpochTimestampProvider, @TemporaryUrlKey Supplier<String> temporaryUrlKeySupplier, Function<Invocation, HttpRequest> processor, Class<T> ownerType) throws SecurityException, NoSuchMethodException {
        this.processor = Preconditions.checkNotNull(processor, "processor");
        this.crypto = Preconditions.checkNotNull(crypto, "crypto");
        this.unixEpochTimestampProvider = Preconditions.checkNotNull(unixEpochTimestampProvider, "unixEpochTimestampProvider");
        this.temporaryUrlKeySupplier = Preconditions.checkNotNull(temporaryUrlKeySupplier, "temporaryUrlKeyProvider");
        this.blobToObject = Preconditions.checkNotNull(blobToObject, "blobToObject");
        this.blob2HttpGetOptions = Preconditions.checkNotNull(blob2HttpGetOptions, "blob2HttpGetOptions");
        this.getMethod = Reflection2.method(ownerType, "getObject", String.class, String.class, GetOptions[].class);
        this.deleteMethod = Reflection2.method(ownerType, "removeObject", String.class, String.class);
        this.createMethod = Reflection2.method(ownerType, "putObject", String.class, SwiftObject.class);
    }

    @Override
    public HttpRequest signGetBlob(String container, String name) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        return BlobStoreUtils.cleanRequest(this.processor.apply(Invocation.create(this.getMethod, ImmutableList.of(container, name))));
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        HttpRequest request = this.processor.apply(Invocation.create(this.getMethod, ImmutableList.of(container, name)));
        return BlobStoreUtils.cleanRequest(this.signForTemporaryAccess(request, timeInSeconds));
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        return BlobStoreUtils.cleanRequest(this.processor.apply(Invocation.create(this.getMethod, ImmutableList.of(container, name, this.blob2HttpGetOptions.apply(Preconditions.checkNotNull(options, "options"))))));
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(blob, "blob");
        return BlobStoreUtils.cleanRequest(this.processor.apply(Invocation.create(this.createMethod, ImmutableList.of(container, this.blobToObject.apply(blob)))));
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(blob, "blob");
        HttpRequest request = this.processor.apply(Invocation.create(this.createMethod, ImmutableList.of(container, this.blobToObject.apply(blob))));
        return BlobStoreUtils.cleanRequest(this.signForTemporaryAccess(request, timeInSeconds));
    }

    @Override
    public HttpRequest signRemoveBlob(String container, String name) {
        Preconditions.checkNotNull(container, "container");
        Preconditions.checkNotNull(name, "name");
        return BlobStoreUtils.cleanRequest(this.processor.apply(Invocation.create(this.deleteMethod, ImmutableList.of(container, name))));
    }

    private HttpRequest signForTemporaryAccess(HttpRequest request, long timeInSeconds) {
        Object builder = ((HttpRequest.Builder)request.toBuilder()).filters(ImmutableSet.<HttpRequestFilter>of());
        String key = this.temporaryUrlKeySupplier.get();
        if (key == null) {
            throw new UnsupportedOperationException();
        }
        long expiresInSeconds = this.unixEpochTimestampProvider.get() + timeInSeconds;
        ((HttpRequest.Builder)builder).addQueryParam("temp_url_sig", this.createSignature(key, this.createStringToSign(request.getMethod().toUpperCase(), request, expiresInSeconds)));
        ((HttpRequest.Builder)builder).addQueryParam("temp_url_expires", "" + expiresInSeconds);
        return ((HttpRequest.Builder)builder).build();
    }

    private String createStringToSign(String method, HttpRequest request, long expiresInSeconds) {
        Preconditions.checkArgument(method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("PUT"));
        return String.format("%s\n%d\n%s", method.toUpperCase(), expiresInSeconds, request.getEndpoint().getPath());
    }

    private String createSignature(String key, String toSign) {
        try {
            ByteProcessor<byte[]> hmacSHA1 = Macs.asByteProcessor(this.crypto.hmacSHA1(key.getBytes(Charsets.UTF_8)));
            return BaseEncoding.base16().lowerCase().encode(ByteStreams.readBytes(Strings2.toInputStream(toSign), hmacSHA1));
        }
        catch (InvalidKeyException e) {
            throw Throwables.propagate(e);
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }
}

