/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.security.xml;

import java.util.ArrayList;
import java.util.List;
import org.duracloud.SecurityUserType;
import org.duracloud.SecurityUsersDocument;
import org.duracloud.SecurityUsersType;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.security.domain.SecurityUserBean;

public class SecurityUserElementReader {
    public static List<SecurityUserBean> createSecurityUsersFrom(SecurityUsersDocument doc) {
        ArrayList<SecurityUserBean> beans = new ArrayList<SecurityUserBean>();
        SecurityUsersType usersType = doc.getSecurityUsers();
        if (usersType.sizeOfSecurityUserArray() > 0) {
            SecurityUserElementReader.checkSchemaVersion(usersType.getSchemaVersion());
            for (SecurityUserType userType : usersType.getSecurityUserArray()) {
                beans.add(SecurityUserElementReader.createSecurityUser(userType));
            }
        }
        return beans;
    }

    private static SecurityUserBean createSecurityUser(SecurityUserType userType) {
        String username = userType.getUsername();
        String password = userType.getPassword();
        String email = userType.getEmail();
        String ipLimits = userType.getIpLimits();
        boolean enabled = userType.getEnabled();
        boolean credentialsNonExpired = userType.getCredentialsNonExpired();
        boolean accountNonExpired = userType.getAccountNonExpired();
        boolean accountNonLocked = userType.getAccountNonLocked();
        List authorities = userType.getGrantedAuthorities();
        List groups = userType.getGroups();
        return new SecurityUserBean(username, password, email, ipLimits, enabled, credentialsNonExpired, accountNonExpired, accountNonLocked, authorities, groups);
    }

    private static void checkSchemaVersion(String schemaVersion) {
        if (!schemaVersion.equals("1.3")) {
            throw new DuraCloudRuntimeException("Unsupported schema version: " + schemaVersion);
        }
    }
}

