/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.jdo.DefaultJdoDialect;
import org.springframework.orm.jdo.JdoDialect;

@Deprecated
public abstract class JdoAccessor
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PersistenceManagerFactory persistenceManagerFactory;
    private JdoDialect jdoDialect;
    private boolean flushEager = false;

    public void setPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        this.persistenceManagerFactory = pmf;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    public void setJdoDialect(JdoDialect jdoDialect) {
        this.jdoDialect = jdoDialect;
    }

    public JdoDialect getJdoDialect() {
        if (this.jdoDialect == null) {
            this.jdoDialect = new DefaultJdoDialect();
        }
        return this.jdoDialect;
    }

    public void setFlushEager(boolean flushEager) {
        this.flushEager = flushEager;
    }

    public boolean isFlushEager() {
        return this.flushEager;
    }

    public void afterPropertiesSet() {
        if (this.getPersistenceManagerFactory() == null) {
            throw new IllegalArgumentException("Property 'persistenceManagerFactory' is required");
        }
        if (this.jdoDialect == null) {
            this.jdoDialect = new DefaultJdoDialect(this.getPersistenceManagerFactory().getConnectionFactory());
        }
    }

    protected void flushIfNecessary(PersistenceManager pm, boolean existingTransaction) throws JDOException {
        if (this.isFlushEager()) {
            this.logger.debug("Eagerly flushing JDO persistence manager");
            pm.flush();
        }
    }

    public DataAccessException convertJdoAccessException(JDOException ex) {
        return this.getJdoDialect().translateException(ex);
    }
}

