/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.Context;
import org.jclouds.annotations.Name;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.lifecycle.Closer;
import org.jclouds.location.Provider;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.Utils;
import org.jclouds.util.Closeables2;

@Singleton
public class ContextImpl
implements Context {
    private final ProviderMetadata providerMetadata;
    private final Supplier<Credentials> creds;
    private final Utils utils;
    private final Closer closer;
    private final String name;

    @Inject
    protected ContextImpl(@Name String name, ProviderMetadata providerMetadata, @Provider Supplier<Credentials> creds, Utils utils, Closer closer) {
        this.providerMetadata = Preconditions.checkNotNull(providerMetadata, "providerMetadata");
        this.creds = Preconditions.checkNotNull(creds, "creds");
        this.utils = Preconditions.checkNotNull(utils, "utils");
        this.closer = Preconditions.checkNotNull(closer, "closer");
        this.name = Preconditions.checkNotNull(name, "name");
    }

    @Override
    public void close() {
        Closeables2.closeQuietly(this.closer);
    }

    @Override
    public boolean isOpen() {
        return this.closer.getState() == Closer.State.AVAILABLE;
    }

    @Override
    public ProviderMetadata getProviderMetadata() {
        return this.providerMetadata;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIdentity() {
        return this.creds.get().identity;
    }

    @Override
    public Utils utils() {
        return this.utils;
    }

    public int hashCode() {
        return Objects.hashCode(this.providerMetadata, this.creds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextImpl that = (ContextImpl)ContextImpl.class.cast(obj);
        return Objects.equal(this.providerMetadata, that.providerMetadata) && Objects.equal(this.creds, that.creds);
    }

    public String toString() {
        return Objects.toStringHelper("").add("providerMetadata", this.providerMetadata).add("identity", this.getIdentity()).toString();
    }

    @Override
    public String getDescription() {
        return this.providerMetadata.getName();
    }

    @Override
    public String getId() {
        return this.providerMetadata.getId();
    }

    @Override
    public Set<String> getIso3166Codes() {
        return this.providerMetadata.getIso3166Codes();
    }

    @Override
    public Map<String, Object> getMetadata() {
        return ImmutableMap.of("endpoint", URI.create(this.providerMetadata.getEndpoint()), "apiVersion", this.providerMetadata.getApiMetadata().getVersion(), "buildVersion", this.providerMetadata.getApiMetadata().getBuildVersion().or(""), "identity", this.getIdentity());
    }

    @Override
    public Location getParent() {
        return null;
    }

    @Override
    public LocationScope getScope() {
        return LocationScope.PROVIDER;
    }
}

