/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.util.Predicates2;

@Deprecated
public abstract class BaseAsyncBlobStore
implements AsyncBlobStore {
    protected final BlobStoreContext context;
    protected final BlobUtils blobUtils;
    protected final ListeningExecutorService userExecutor;
    protected final Supplier<Location> defaultLocation;
    protected final Supplier<Set<? extends Location>> locations;

    @Inject
    protected BaseAsyncBlobStore(BlobStoreContext context, BlobUtils blobUtils, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations) {
        this.context = Preconditions.checkNotNull(context, "context");
        this.blobUtils = Preconditions.checkNotNull(blobUtils, "blobUtils");
        this.userExecutor = Preconditions.checkNotNull(userExecutor, "userExecutor");
        this.defaultLocation = Preconditions.checkNotNull(defaultLocation, "defaultLocation");
        this.locations = Preconditions.checkNotNull(locations, "locations");
    }

    @Override
    public BlobStoreContext getContext() {
        return this.context;
    }

    @Override
    public BlobBuilder blobBuilder(String name) {
        return this.blobUtils.blobBuilder().name(name);
    }

    @Override
    public ListenableFuture<PageSet<? extends StorageMetadata>> list(String container) {
        return this.list(container, ListContainerOptions.NONE);
    }

    @Override
    public ListenableFuture<Long> countBlobs(String container) {
        return this.countBlobs(container, ListContainerOptions.Builder.recursive());
    }

    @Override
    public ListenableFuture<Long> countBlobs(final String containerName, final ListContainerOptions options) {
        return this.userExecutor.submit(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return BaseAsyncBlobStore.this.blobUtils.countBlobs(containerName, options);
            }

            public String toString() {
                return "countBlobs(" + containerName + ")";
            }
        });
    }

    @Override
    public ListenableFuture<Void> clearContainer(String container) {
        return this.clearContainer(container, ListContainerOptions.Builder.recursive());
    }

    @Override
    public ListenableFuture<Void> clearContainer(final String containerName, final ListContainerOptions options) {
        return this.userExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BaseAsyncBlobStore.this.blobUtils.clearContainer(containerName, options);
                return null;
            }

            public String toString() {
                return "clearContainer(" + containerName + ")";
            }
        });
    }

    @Override
    public ListenableFuture<Void> deleteDirectory(final String containerName, final String directory) {
        return this.userExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BaseAsyncBlobStore.this.blobUtils.deleteDirectory(containerName, directory);
                return null;
            }

            public String toString() {
                return "deleteDirectory(" + containerName + "," + directory + ")";
            }
        });
    }

    @Override
    public ListenableFuture<Boolean> directoryExists(final String containerName, final String directory) {
        return this.userExecutor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return BaseAsyncBlobStore.this.blobUtils.directoryExists(containerName, directory);
            }

            public String toString() {
                return "directoryExists(" + containerName + "," + directory + ")";
            }
        });
    }

    @Override
    public ListenableFuture<Void> createDirectory(final String containerName, final String directory) {
        return this.blobUtils.directoryExists(containerName, directory) ? Futures.immediateFuture(null) : this.userExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BaseAsyncBlobStore.this.blobUtils.createDirectory(containerName, directory);
                return null;
            }

            public String toString() {
                return "createDirectory(" + containerName + "," + directory + ")";
            }
        });
    }

    @Override
    public ListenableFuture<Blob> getBlob(String container, String key) {
        return this.getBlob(container, key, GetOptions.NONE);
    }

    @Override
    public ListenableFuture<Void> deleteContainer(final String container) {
        return this.userExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BaseAsyncBlobStore.this.deletePathAndEnsureGone(container);
                return null;
            }

            public String toString() {
                return "deleteContainer(" + container + ")";
            }
        });
    }

    @Override
    public ListenableFuture<Boolean> deleteContainerIfEmpty(final String container) {
        return this.userExecutor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return BaseAsyncBlobStore.this.deleteAndVerifyContainerGone(container);
            }

            public String toString() {
                return "deleteContainerIfEmpty(" + container + ")";
            }
        });
    }

    protected void deletePathAndEnsureGone(String path) {
        Preconditions.checkState(Predicates2.retry(new Predicate<String>(){

            @Override
            public boolean apply(String in) {
                try {
                    BaseAsyncBlobStore.this.blobUtils.clearContainer(in, ListContainerOptions.Builder.recursive());
                    return BaseAsyncBlobStore.this.deleteAndVerifyContainerGone(in);
                }
                catch (ContainerNotFoundException e) {
                    return true;
                }
            }
        }, 30000L).apply(path), "%s still exists after deleting!", path);
    }

    @Override
    public ListenableFuture<Set<? extends Location>> listAssignableLocations() {
        return Futures.immediateFuture(this.locations.get());
    }

    protected abstract boolean deleteAndVerifyContainerGone(String var1);
}

