/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.data.repository.util.NullableWrapper;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class QueryExecutionConverters {
    private static final boolean GUAVA_PRESENT = ClassUtils.isPresent("com.google.common.base.Optional", QueryExecutionConverters.class.getClassLoader());
    private static final boolean JDK_PRESENT = ClassUtils.isPresent("java.util.Optional", QueryExecutionConverters.class.getClassLoader());
    private static Set<Class<?>> WRAPPER_TYPES = new HashSet();

    public static boolean supports(Class<?> type) {
        Assert.notNull(type, "Type must not be null!");
        return WRAPPER_TYPES.contains(type);
    }

    public static void registerConvertersIn(ConfigurableConversionService conversionService) {
        Assert.notNull(conversionService, "ConversionService must not be null!");
        if (GUAVA_PRESENT) {
            conversionService.addConverter(new NullableWrapperToGuavaOptionalConverter(conversionService));
        }
        if (JDK_PRESENT) {
            conversionService.addConverter(new NullableWrapperToJdk8OptionalConverter(conversionService));
        }
        conversionService.addConverter(new NullableWrapperToFutureConverter(conversionService));
    }

    static {
        WRAPPER_TYPES.add(Future.class);
        if (GUAVA_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToGuavaOptionalConverter.getWrapperType());
        }
        if (JDK_PRESENT) {
            WRAPPER_TYPES.add(NullableWrapperToJdk8OptionalConverter.getWrapperType());
        }
    }

    private static class NullableWrapperToFutureConverter
    extends AbstractWrapperTypeConverter {
        private final AsyncResult<Object> NULL_OBJECT = new AsyncResult<Object>(null);

        public NullableWrapperToFutureConverter(ConversionService conversionService) {
            super(conversionService, Future.class);
        }

        @Override
        protected Object getNullValue() {
            return this.NULL_OBJECT;
        }

        @Override
        protected Object wrap(Object source) {
            return new AsyncResult<Object>(source);
        }
    }

    private static class NullableWrapperToJdk8OptionalConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToJdk8OptionalConverter(ConversionService conversionService) {
            super(conversionService, Optional.class);
        }

        @Override
        protected Object getNullValue() {
            return Optional.empty();
        }

        @Override
        protected Object wrap(Object source) {
            return Optional.of(source);
        }

        public static Class<?> getWrapperType() {
            return Optional.class;
        }
    }

    private static class NullableWrapperToGuavaOptionalConverter
    extends AbstractWrapperTypeConverter {
        public NullableWrapperToGuavaOptionalConverter(ConversionService conversionService) {
            super(conversionService, com.google.common.base.Optional.class);
        }

        @Override
        protected Object getNullValue() {
            return com.google.common.base.Optional.absent();
        }

        @Override
        protected Object wrap(Object source) {
            return com.google.common.base.Optional.of(source);
        }

        public static Class<?> getWrapperType() {
            return com.google.common.base.Optional.class;
        }
    }

    private static abstract class AbstractWrapperTypeConverter
    implements GenericConverter {
        private final ConversionService conversionService;
        private final Class<?> wrapperType;

        protected AbstractWrapperTypeConverter(ConversionService conversionService, Class<?> wrapperType) {
            Assert.notNull(conversionService, "ConversionService must not be null!");
            Assert.notNull(wrapperType, "Wrapper type must not be null!");
            this.conversionService = conversionService;
            this.wrapperType = wrapperType;
        }

        @Override
        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(NullableWrapper.class, this.wrapperType));
        }

        @Override
        public final Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            NullableWrapper wrapper = (NullableWrapper)source;
            Object value = wrapper.getValue();
            return value == null ? this.getNullValue() : this.wrap(value);
        }

        protected abstract Object getNullValue();

        protected abstract Object wrap(Object var1);
    }
}

